package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructor;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.ds.FoggyRefMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.action.trade.IBartererMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.IItemMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.process.IProcessMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.IPawn;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.PawnReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.trade.IBartererReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IMergeableItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.process.IProcessReplica;

public class PawnMemorization<MemorizedClass extends PawnReplica> 
	extends cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.PawnMemorization<MemorizedClass> 
	implements IPawn, IBartererMemorization<MemorizedClass> {
	
	protected IProcessMemorization<IProcessReplica> process;
	protected FoggyRefMemorization<IBartererMemorization<IBartererReplica>> barterProposer;
	protected List<IItemMemorization<IItemReplica>> inventory;
	
	public PawnMemorization( 
		final MemorizedClass object,
		final ObservationMemory observationMemory,
		IDeferredConstructorChainer deferredConstructorChainer
	) {
		super( object, observationMemory );
		
		deferredConstructorChainer.addDeferredConstructor( 
			new IDeferredConstructor() {
				@Override
				public void construct() {
					process  = (IProcessMemorization<IProcessReplica>) observationMemory.getMemorization( object.getProcess() );
					if ( object.isBarterProposerHidden() ) {
						barterProposer = new FoggyRefMemorization<IBartererMemorization<IBartererReplica>>( true, null );
					} else {
						barterProposer = new FoggyRefMemorization<IBartererMemorization<IBartererReplica>>(
							false, 
							(IBartererMemorization<IBartererReplica>) observationMemory.getMemorization( object.getBarterProposer() )
						);
					}
					inventory = new LinkedList<IItemMemorization<IItemReplica>>();
					for ( IItemReplica item : object.readInventory() ) {
						inventory.add( (IItemMemorization<IItemReplica>) observationMemory.getMemorization( item ) );
					}
				}
			}
		);
	}
		
	@Override
	public boolean canPickUp( IItem item) {
		return true;
	}

	@Override
	public boolean canDrop( IItem item) {
		return true;
	}

	@Override
	public boolean canSplit( IItem item) {
		return true;
	}

	@Override
	public boolean canMerge( IMergeableItem mergedItem, IMergeableItem dissolvedItem) {
		return true;
	}


	@Override
	public Collection<? extends IItemMemorization<IItemReplica>> readInventory() {
		return Collections.unmodifiableList( inventory );
	}
	
	@Override
	public IProcessMemorization<IProcessReplica> getProcess() {
		return process;
	}

	@Override
	public boolean isBarterProposerHidden() {
		return barterProposer.isHidden();
	}
	
	@Override
	public IBartererMemorization<? extends IBartererReplica> getBarterProposer() {
		return barterProposer.get();
	}
}
