package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.essence;

import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.PawnReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.ActionRegistryReplica;

/** Association map interface
 * 
 * @author Paletz
 */
public interface IEssenceMap extends cz.cuni.amis.pogamut.emohawk.agent.module.essence.IEssenceMap {
	
	/** Retrieve PawnReplica object associated with given bot ID if such exists
	 * 
	 * @param botId bot ID
	 * @return PawnReplica object associated with given bot ID if such exists, null otherwise
	 */
	PawnReplica retrievePawn( String botId );
	
	/** Retrieve PawnReplica object associated with given world object if such exists
	 * 
	 * @param worldObject world object
	 * @return PawnReplica object associated with given world object if such exists, null otherwise
	 */
	PawnReplica retrievePawn( IWorldObject worldObject );
	
	/** Retrive action registry
	 *
	 * @return action registry
	 */
	ActionRegistryReplica retrieveActionRegistry();
}
