package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.collector;

import cz.cuni.amis.pogamut.emohawk.agent.module.essence.EssenceDistanceTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.AbstractActionReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.SerializationTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.StreamBuffer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;

/** Pick up an item action
 */
public class PickUpItemActionReplica extends AbstractActionReplica {
	
	public static final int ERROR_COLLECTOR_DENIED = 10;
	public static final int ERROR_TARGET_INVALID = 11;
	public static final int ERROR_PERFORMER_NOT_COLLECTOR = 12;
	public static final int ERROR_TARGET_NOT_PLACED = 13;
	public static final int ERROR_TARGET_OUT_OF_REACH = 14;
	
	public static final float DEFAULT_RANGE = 100.0f;
	
	protected static final String RANGE_ATTR = "range";
	
	/** Constructor
	 */
	public PickUpItemActionReplica() {
	}
	
	@Override
	public String getActionName() {
		return "Pick up item";
	}
	
	/** Get range
	 */
	public float getRange() {
		return attributes.floats().get( RANGE_ATTR );
	}
	
	/** Tell if the collector can reach the item
	 */
	public boolean canReach( ICollector collector, IItem item, double rangeMultiplier )
	{
		return (
			EssenceDistanceTools.computeDistanceOfEssences( collector, item )
			<=
			getRange()*rangeMultiplier
		);
	}
	
	/** Request
	 * 
	 * Client-side only.
	 * 
	 * @param performer action performer
	 * @param item item to pick up
	 * @param resultHandler result handler
	 */
	public void request( ICollectorReplica performer, IItemReplica item, IActionResultHandler resultHandler )
	{
		StreamBuffer arguments = new StreamBuffer();
		SerializationTools.serializeObjectReferenceOnClient( arguments, item );
		performer.requestAction( 
			this, 
			resultHandler, 
			arguments 
		);
	}
}
