package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.collector;

import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IMergeableItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.IPossessor;

/** Object capable of picking up, dropping, splitting and merging of items.
 */
public interface ICollector extends IPossessor {
	
	/** Tell whether collector can pick up the item
	 * 
	 * Also applies to taking item from container.
	 */
	boolean canPickUp( IItem item );

	/** Tell whether collector can drop the item
	 * 
	 * Also applies to storing item in container.
	 */
	boolean canDrop( IItem item );

	/** Tell whether collector can split the item
	 * 
	 * This doesn't check whether item is splittable.
	 */
	boolean canSplit( IItem item );
	
	/** Tell whether collector can merge the items
	 * 
	 * This doesn't check whether the items are compatible.
	 */
	boolean canMerge( IMergeableItem mergedItem, IMergeableItem dissolvedItem );
}
