package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image;

import java.util.Collection;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.ObjectReplicationClient;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.ReplicationId;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.trade.IBartererReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IMergeableItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.PossessorComponent;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.process.IProcessReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.process.ExecutorComponent;

/** RPG base player pawn
 * 
 * @author Paletz
 */
public class PawnReplica 
	extends cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.PawnReplica 
	implements IPawn, IBartererReplica {
	
	public static final String BARTER_PROPOSER_ATTR = "barterProposer";
	
	protected PossessorComponent possessorComponent;
	protected ExecutorComponent executorComponent;
	
	/** Constructor
	 */
	public PawnReplica() {
	}
	
	@Override
	public Collection<? extends IItemReplica> readInventory()
	{
		return possessorComponent.readInventory();
	}
	
	@Override
	public boolean isBarterProposerHidden() {
		return getAttributes().refs().isHidden( BARTER_PROPOSER_ATTR );
	}
	
	@Override
	public IBartererReplica getBarterProposer() {
		return (IBartererReplica) getAttributes().refs().get( BARTER_PROPOSER_ATTR );
	}
	
	@Override
	public IProcessReplica getProcess() {
		return executorComponent.getProcess();
	}
	
	@Override
	public boolean canPickUp( IItem item) {
		return true;
	}

	@Override
	public boolean canDrop( IItem item) {
		return true;
	}

	@Override
	public boolean canSplit( IItem item) {
		return true;
	}

	@Override
	public boolean canMerge( IMergeableItem mergedItem, IMergeableItem dissolvedItem) {
		return true;
	}
	
	@Override 
	public void initializeImage( ObjectReplicationClient initObjectReplicationClient, ReplicationId initReplicationId) {
		super.initializeImage( initObjectReplicationClient, initReplicationId );
		possessorComponent = new PossessorComponent( this,  this );
		executorComponent = new ExecutorComponent( this );
	}
}
