package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructor;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.essence.AbstractEssenceMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.container.IPossessorMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.AbstractItem;

public class AbstractItemMemorization
	<MemorizedClass extends AbstractItem>
	extends AbstractEssenceMemorization<MemorizedClass>
	implements IItemMemorization<MemorizedClass> {

	protected IPossessorMemorization<?> ownerPossessor;
	protected String displayName;
	
	public AbstractItemMemorization(
		final MemorizedClass object,
		final ObservationMemory observationMemory,
		IDeferredConstructorChainer deferredConstructorChainer
	) {
		super( object, observationMemory );
		displayName = object.getDisplayName();
		
		deferredConstructorChainer.addDeferredConstructor(
			new IDeferredConstructor() {
				@Override
				public void construct() {
					ownerPossessor =  (IPossessorMemorization<?>) observationMemory.getMemorization( object.getOwnerPossessor() );
				}
			}
		);
		
	}
	
	@Override
	public IPossessorMemorization<?> getOwnerPossessor() {
		return ownerPossessor;
	}

	@Override
	public String getDisplayName() {
		return displayName;
	}
}
