package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.trade;

import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;

/** Process of trading
 * 
 * @author Paletz
 */
public interface ITradeProcess {

	/** Tell if barter partner is hidden
	 */
	boolean isBarterPartnerHidden();
	
	/** Get barter partner
	 */
	IBarterer getBarterPartner();

	/** Get barter partners trade process
	 */
	ITradeProcess getBarterPartnerProcess();

	/** Tell whether trade mutually established
	 */
	boolean isEstablished();

	/** Tell if deal has been accepted by local side
	 */
	boolean hasAccepted();

	/** Read offer
	 *  
	 * @return list of offered items
	 */
	Iterable<? extends IItem> readOffer();
	
	/** Get time when last offer change occured
	 *  
	 * @return time when last offer change occured
	 */
	public float getLastOfferChangeTime();
}
