package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.AbstractActionReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IPerformerReplication;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.process.IExecutorReplication;

/** Interrupt action execution action
 */
public class InterruptProcessActionReplication extends AbstractActionReplication {
	
	/** Error code sent to the requester of the interrupted action
	 */
	public static final int ERROR_INTERRUPTED = 5;
	
	public static final int ERROR_PERFORMER_NOT_EXECUTOR = 10;
	public static final int ERROR_NOTHING_TO_INTERRUPT = 11;
	public static final int ERROR_NOT_INTERRUPTIBLE = 12;
	
	/** Constructor
	 */
	public InterruptProcessActionReplication() {
	}
	
	@Override
	public String getActionName() {
		return "Interrupt action execution";
	}
	
	/** Request to interrupt execution
	 * 
	 * Send request to server.
	 * 
	 * @param performer action performer
	 * @param resultHandler result handler
	 */
	public <Executor extends IExecutorReplication & IPerformerReplication> void request( Executor performer, IActionResultHandler resultHandler )
	{
		((IPerformerReplication) performer).requestAction(
			this,
			resultHandler,
			null
		);
	}
}