package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image;

import java.util.Collection;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.ObjectReplicationClient;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.ReplicationId;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.trade.IBartererReplication;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplication;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IMergeableItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.WarehouseComponent;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.process.IProcessReplication;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.process.ExecutorComponent;

/** RPG base player pawn
 * 
 * @author Paletz
 */
public class PawnReplication 
	extends cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.PawnReplication 
	implements IPawn, IBartererReplication {
	
	public static final String BARTER_PROPOSER_ATTR = "barterProposer";
	
	protected WarehouseComponent warehouseComponent;
	protected ExecutorComponent executorComponent;
	
	/** Constructor
	 */
	public PawnReplication() {
	}
	
	@Override
	public Collection<? extends IItemReplication> readInventory()
	{
		return warehouseComponent.readInventory();
	}
	
	@Override
	public boolean isBarterProposerHidden() {
		return getAttributes().refs().isHidden( BARTER_PROPOSER_ATTR );
	}
	
	@Override
	public IBartererReplication getBarterProposer() {
		return (IBartererReplication) getAttributes().refs().get( BARTER_PROPOSER_ATTR );
	}
	
	@Override
	public IProcessReplication getProcess() {
		return executorComponent.getProcess();
	}
	
	@Override
	public boolean canPickUp( IItem item) {
		return true;
	}

	@Override
	public boolean canDrop( IItem item) {
		return true;
	}

	@Override
	public boolean canSplit( IItem item) {
		return true;
	}

	@Override
	public boolean canMerge( IMergeableItem mergedItem, IMergeableItem dissolvedItem) {
		return true;
	}
	
	@Override 
	public void initializeImage( ObjectReplicationClient initObjectReplicationClient, ReplicationId initReplicationId) {
		super.initializeImage( initObjectReplicationClient, initReplicationId );
		warehouseComponent = new WarehouseComponent( this,  this );
		executorComponent = new ExecutorComponent( this );
	}
}
