package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.AbstractSubstanceItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IMergeableItem;

public class AbstractSubstanceItemMemorization
	<MemorizedClass extends AbstractSubstanceItem> 
	extends AbstractItemMemorization<MemorizedClass>
	implements ISubstanceItemMemorization<MemorizedClass> {
	
	protected float amount;
	protected String amountUnitName;
	
	public AbstractSubstanceItemMemorization(
		MemorizedClass object,
		ObservationMemory observationMemory,
		IDeferredConstructorChainer deferredConstructorChainer 
	) {
		super(object, observationMemory, deferredConstructorChainer);
		amount = object.getAmount();
		amountUnitName = object.getAmountUnitName();
	}

	@Override
	public float getAmount() {
		return amount;
	}

	@Override
	public String getAmountUnitName() {
		return amountUnitName;
	}

	@Override
	public boolean canMerge(IMergeableItem otherItem) {
		// class comparison wouldn't handle mixing of torn-off and live objects
		return otherItem.getDisplayName().equals( getDisplayName() );
	}
}
