package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.essence;

import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.PawnReplication;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.ActionRegistryReplication;

/** Map of associations of replicable objects for emohawk rpg base
 * 
 * This map is aware of rpg base specialized classes.
 * @author Paletz
 */
public class EssenceMap extends cz.cuni.amis.pogamut.emohawk.agent.module.essence.EssenceMap implements IEssenceMap {
	
	public EssenceMap(IVisionWorldView worldView) {
		super(worldView);
	}

	/** Associate action registry
	 * 
	 * @param actionRegistry action registry, must be emohawk rpg base action registry
	 */
	public void associateActionRegistry( 
		cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.ActionRegistryReplication actionRegistry 
	) {
		assert( actionRegistry instanceof ActionRegistryReplication );
		this.actionRegistry = actionRegistry;
	}
	
	/** Associate Pawn object with a bot ID
	 * 
	 * @param botId bot ID
	 * @param pawn Pawn object, must be RPG base pawn
	 */
	@Override
	public void associatePawn(String botId, cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.PawnReplication pawn) {
		assert( pawn instanceof PawnReplication );
		super.associatePawn(botId, pawn);
	}
	
	@Override
	public PawnReplication retrievePawn( String botId ) {
		return (PawnReplication) super.retrievePawn(botId);
	}
	
	@Override
	public PawnReplication retrievePawn( IWorldObject worldObject ) {
		return (PawnReplication) super.retrievePawn(worldObject);
	}
	
	@Override
	public ActionRegistryReplication retrieveActionRegistry() {
		return (ActionRegistryReplication) actionRegistry;
	}
}
