package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructor;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.essence.AbstractEssenceMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.container.IWarehouseMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.AbstractItem;

public class AbstractItemMemorization
	<MemorizedClass extends AbstractItem>
	extends AbstractEssenceMemorization<MemorizedClass>
	implements IItemMemorization<MemorizedClass> {

	protected IWarehouseMemorization<?> ownerWarehouse;
	protected String displayName;
	
	public AbstractItemMemorization(
		final MemorizedClass object,
		final ObservationMemory observationMemory,
		IDeferredConstructorChainer deferredConstructorChainer
	) {
		super( object, observationMemory );
		displayName = object.getDisplayName();
		
		deferredConstructorChainer.addDeferredConstructor(
			new IDeferredConstructor() {
				@Override
				public void construct() {
					ownerWarehouse =  (IWarehouseMemorization<?>) observationMemory.getMemorization( object.getOwnerWarehouse() );
				}
			}
		);
		
	}
	
	@Override
	public IWarehouseMemorization<?> getOwnerWarehouse() {
		return ownerWarehouse;
	}

	@Override
	public String getDisplayName() {
		return displayName;
	}
}
