package cz.cuni.amis.pogamut.defcon.utils;

import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

import javabot.PogamutJBotSupport;

/**
 * Container for execution of queries from game info in the main thread from
 * other threads.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class SyncMethodExecContainer {
	public volatile Method method;
	public volatile Object[] parameters;
	public volatile Object returnValue = null;
	public volatile Object lock = new Object();
	public volatile boolean used = false;

	public SyncMethodExecContainer(Method method, Object[] parameters) {

		if (method == null)
			throw new IllegalArgumentException(
					"method argument cannot be null.");

		this.method = method;
		this.parameters = parameters;
	}

	/**
	 * Called in the main thread to execute herein contained method with a given
	 * parameters and collecting the return value.
	 */
	public void execute() {
		synchronized (lock) {
			try {
				this.returnValue = method.invoke(null, parameters);
			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				latch.countDown();
			}
		}
	}
	
	private final CountDownLatch latch = new CountDownLatch(1);

	/**
	 * Enqueue and wait for execution of the herein contained method in the main
	 * thread.
	 * 
	 * @return
	 */
	public Object syncCallInMainThread() {

		synchronized (lock) {
			if (used)
			throw new RuntimeException(
					"Called twice! Previous call must finish first!");
			used = true;
		}


		PogamutJBotSupport.addQuery(this);
		try {
			latch.await(10000, TimeUnit.MILLISECONDS);
		} catch (InterruptedException e) {
			PogamutJBotSupport.writeToConsole("Intteruped waiting");
		} catch (Exception e) {
			PogamutJBotSupport.writeToConsole("Exception!");
			e.printStackTrace();
			e.getCause().printStackTrace();
		}

		return returnValue;
	}
	
	public Object getLock() {
		return lock;
	}
}
