package cz.cuni.amis.pogamut.defcon.consts;

import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.*;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConEvent;
import cz.cuni.amis.pogamut.defcon.consts.state.*;

import java.util.HashMap;
import java.util.Map;

import javabot.JBot;

import javabot.JBot.EventData;

/**
 * Contains all types of defcon events and supplies user with a factory method for each of them.
 * GENERATED by EventFactoryGenerator.xslt so any modifications should go there!!!  
 * 
 * @author Radek 'Black_Hand' Pibil          
 */
public enum Event {PING_SUB(JBot.EventPingSub), PING_CARRIER(JBot.EventPingCarrier), 
    NUKE_LAUNCH_SILO(JBot.EventNukeLaunchSilo), NUKE_LAUNCH_SUB(JBot.EventNukeLaunchSub), 
    HIT(JBot.EventHit), DESTROYED(JBot.EventDestroyed), PING_DETECTION(JBot.EventPingDetection), 
    CEASED_FIRE(JBot.EventCeasedFire), UNCEASED_FIRE(JBot.EventUnceasedFire), 
    SHARED_RADAR(JBot.EventSharedRadar), UNSHARED_RADAR(JBot.EventUnsharedRadar), 
    NEW_VOTE(JBot.EventNewVote), TEAM_VOTED(JBot.EventTeamVoted), 
    TEAM_RETRACTED_VOTE(JBot.EventTeamRetractedVote), VOTE_FINISHED_YES(JBot.EventVoteFinishedYes), 
    VOTE_FINISHED_NO(JBot.EventVoteFinishedNo);
    /**
     * Contains mapping from integer (defcon) unit type to UnitType enum. Used when
     * translation from "int" to Event is needed, i.e., when {@link Event#getEnum(int)} is called.
     */
    private static Map<Integer, Event> enums = new HashMap<Integer, Event>();

    /**
     * Returns appropriate Event for given integer.
     *
     * @param eventId integer (defcon) event type
     *
     * @return Event type
     */
    public static Event getEnum(int eventId) {
        return enums.get(eventId);
    }

    static {
        for (Event item : Event.values()) {
            enums.put(item.id, item);
        }
    }

    /**
     * Holds integer (defcon) event type of this event..type.
     */
    public final int id;

/**
   * Constructor for this enum.
   *
   * @param id integer (defcon) unittype
   */
    private Event(int id) {
        this.id = id;
    }

    /**
     * Factory styled method, which provides you with an appropriate instance of event
     * object based on the given EventData data.
     *
     * @param data event data
     * @param time time of creation
     *
     * @return instantiated defcon event
     */
    public static DefConEvent getInstanceOfUnitTypeFromEventType(EventData data, double time) {
        switch (Event.getEnum(data.m_eventType)) {
        case CEASED_FIRE:return new CeasedFire(Event.getEnum(data.m_eventType),
                data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType),
                new DefConLocation(data.m_longitude, data.m_latitude), time);

        case DESTROYED:return new Destroyed(Event.getEnum(data.m_eventType), data.m_causeObjectId,
                data.m_targetObjectId, UnitType.getEnum(data.m_unitType),
                new DefConLocation(data.m_longitude, data.m_latitude), time);

        case HIT:return new Hit(Event.getEnum(data.m_eventType), data.m_causeObjectId,
                data.m_targetObjectId, UnitType.getEnum(data.m_unitType),
                new DefConLocation(data.m_longitude, data.m_latitude), time);

        case NEW_VOTE:return new NewVote(Event.getEnum(data.m_eventType), data.m_causeObjectId,
                data.m_targetObjectId, UnitType.getEnum(data.m_unitType),
                new DefConLocation(data.m_longitude, data.m_latitude), time);

        case NUKE_LAUNCH_SILO:return new NukeLaunchSilo(Event.getEnum(data.m_eventType),
                data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType),
                new DefConLocation(data.m_longitude, data.m_latitude), time);

        case NUKE_LAUNCH_SUB:return new NukeLaunchSub(Event.getEnum(data.m_eventType),
                data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType),
                new DefConLocation(data.m_longitude, data.m_latitude), time);

        case PING_CARRIER:return new PingCarrier(Event.getEnum(data.m_eventType),
                data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType),
                new DefConLocation(data.m_longitude, data.m_latitude), time);

        case PING_DETECTION:return new PingDetection(Event.getEnum(data.m_eventType),
                data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType),
                new DefConLocation(data.m_longitude, data.m_latitude), time);

        case PING_SUB:return new PingSub(Event.getEnum(data.m_eventType), data.m_causeObjectId,
                data.m_targetObjectId, UnitType.getEnum(data.m_unitType),
                new DefConLocation(data.m_longitude, data.m_latitude), time);

        case SHARED_RADAR:return new SharedRadar(Event.getEnum(data.m_eventType),
                data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType),
                new DefConLocation(data.m_longitude, data.m_latitude), time);

        case TEAM_RETRACTED_VOTE:return new TeamRetractedVoted(Event.getEnum(data.m_eventType),
                data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType),
                new DefConLocation(data.m_longitude, data.m_latitude), time);

        case TEAM_VOTED:return new TeamVoted(Event.getEnum(data.m_eventType), data.m_causeObjectId,
                data.m_targetObjectId, UnitType.getEnum(data.m_unitType),
                new DefConLocation(data.m_longitude, data.m_latitude), time);

        case UNCEASED_FIRE:return new UnceasedFire(Event.getEnum(data.m_eventType),
                data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType),
                new DefConLocation(data.m_longitude, data.m_latitude), time);

        case UNSHARED_RADAR:return new UnsharedRadar(Event.getEnum(data.m_eventType),
                data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType),
                new DefConLocation(data.m_longitude, data.m_latitude), time);

        case VOTE_FINISHED_NO:return new VoteFinishedNo(Event.getEnum(data.m_eventType),
                data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType),
                new DefConLocation(data.m_longitude, data.m_latitude), time);

        case VOTE_FINISHED_YES:return new VoteFinishedYes(Event.getEnum(data.m_eventType),
                data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType),
                new DefConLocation(data.m_longitude, data.m_latitude), time);
        }

        return null;
    }
}
