package cz.cuni.amis.pogamut.defcon.communication.messages.infos;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.IViewable;
import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.messages.Updatable;
import cz.cuni.amis.pogamut.defcon.consts.UnitType;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.IStaticWorldObject;


/**
 * Viewable version of the {@link DefConObject} - implements {@link IViewable} providing a way
 * to tell whether the object is visible on the map.
 *
 * @author Jimmy
 * @author Black_Hand
 */
public abstract class DefConViewableObject extends DefConObject implements IViewable, ILocated {
    /**
     * Holds the information whether the object is visible on the map.
     */
    @Updatable
    protected boolean visible;

    /**
     * Contains location of this object. Exposed via getLocation().
     */
    @Updatable
    protected DefConLocation location;

    /**
     * Contains the id of this object's team. Exposed by getTeamId().
     */
    @Updatable
    protected int teamId;

/**
     * Creates new instance of message DefConViewAbleObject with specific id. Example object from
     * the world.
     *
     * @param id
     * @param type DOCUMENT ME!
     * @param teamId DOCUMENT ME!
     * @param location DOCUMENT ME!
     * @param visible visibility of this object
     * @param time
     */
    public DefConViewableObject(int id, UnitType type, int teamId, DefConLocation location,
        boolean visible, double time) {
        super(id, type, time);

        this.visible = visible;
        this.teamId = teamId;
        this.location = new DefConLocation(location);
    }

/**
     * Creates a new DefConViewableObject object.
     *
     * @param original DOCUMENT ME!
     */
    public DefConViewableObject(DefConViewableObject original) {
        super(original);

        this.visible = original.visible;
        this.teamId = original.teamId;
        this.location = new DefConLocation(original.location);
    }

    /**
     * Is the object visible on the DefCon map?
     *
     * @return visibility
     */
    @Override
    public boolean isVisible() {
        return visible;
    }

    /**
     * Sets the visibility of this object.
     *
     * @param visible
     *
     * @return visibility
     */
    protected boolean setVisibility(boolean visible) {
        return this.visible = visible;
    }

    /**
     * Returns team id of this object.
     *
     * @return id
     */
    public int getTeamId() {
        return teamId;
    }

    /**
     * Returns locations of this object.
     *
     * @return location
     */
    public DefConLocation getLocation() {
        return location;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    @Override
    public String getStringizedFields() {
        return super.getStringizedFields() + "; teamid: " + teamId + "; location: " +
        location.toString() + "; visible: " + visible;
    }

    // TODO: FIX!
    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    @Override
    public ILocalWorldObject getLocal() {
        return (ILocalWorldObject) this;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    @Override
    public ISharedWorldObject getShared() {
        return (ISharedWorldObject) this;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    @Override
    public IStaticWorldObject getStatic() {
        return (IStaticWorldObject) this;
    }
}
