package cz.cuni.amis.pogamut.defcon.communication.command.impl;

import javabot.PogamutJBotSupport;

import com.google.inject.Inject;

import cz.cuni.amis.pogamut.base.communication.command.ICommandListener;
import cz.cuni.amis.pogamut.base.communication.command.impl.IJNIAct;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentPausedException;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.DefConCommand;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;

/**
 * Used to queue up commands in PogamutJBotSupport. It shields user from
 * underlying complexities.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
@AgentScoped
public class DefConAct implements IJNIAct {

	public static final Token COMPONENT_ID = Tokens.get("Act");

	private LogCategory log;

	private IComponentBus eventBus;

	@Inject
	public DefConAct(IComponentBus eventBus, IAgentLogger logger) {
		this.log = logger.getCategory(getComponentId().getToken());

		this.eventBus = eventBus;
	}

	@Override
	public void act(CommandMessage command)
			throws ComponentNotRunningException, ComponentPausedException {

		if (command instanceof DefConCommand)
			PogamutJBotSupport.addCommand((DefConCommand) command);
	}

	@Override
	public void addCommandListener(Class commandClass, ICommandListener listener) {
		PogamutJBotSupport.getDefConActExecutor().addCommandListener(
				commandClass,
				listener);
	}

	@Override
	public boolean isCommandListening(Class commandClass,
			ICommandListener listener) {
		return PogamutJBotSupport.getDefConActExecutor().isCommandListening(
				commandClass,
				listener);
	}

	@Override
	public void removeCommandListener(Class commandClass,
			ICommandListener listener) {
		PogamutJBotSupport.getDefConActExecutor().removeCommandListener(
				commandClass,
				listener);
	}

	@Override
	public IToken getComponentId() {
		return COMPONENT_ID;
	}

}
