package cz.cuni.amis.pogamut.defcon.factory;

import javabot.PogamutJBotSupport;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.name.Names;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.IEmbodiedAgent;
import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.params.impl.AgentParameters;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEventOutput;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentModule;
import cz.cuni.amis.pogamut.base.utils.guice.AdaptableProvider;
import cz.cuni.amis.pogamut.defcon.agent.DefConAgent;
import cz.cuni.amis.pogamut.defcon.agent.IDefConAgent;
import cz.cuni.amis.pogamut.defcon.agent.IDefConAgentController;
import cz.cuni.amis.pogamut.defcon.agent.IDefConAgentLogicController;
import cz.cuni.amis.pogamut.defcon.communication.translator.DefConMessageProducer;
import cz.cuni.amis.pogamut.defcon.communication.worldview.DefConWorldView;

/**
 * Module for guice instantion.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class DefConAgentModule extends GuiceAgentModule<AgentParameters> {	
	
	private Class<? extends DefConAgent> defConAgentClass;
	private Class<? extends IDefConAgentLogicController> defConAgentLogicControllerClass;
	
	private AdaptableProvider<ComponentDependencies> defConDependenciesProvider =
		new AdaptableProvider<ComponentDependencies>(null);	

	public DefConAgentModule(Class<? extends DefConAgent> defConAgentClass,
			Class<? extends IDefConAgentLogicController> defConAgentLogicControllerClass) {
		this.defConAgentClass = defConAgentClass;
		this.defConAgentLogicControllerClass = defConAgentLogicControllerClass;
	}
	
	public Class<? extends DefConAgent> getDefConAgentClass() {
		return defConAgentClass;
	}
	
	/**
	 * Binds runtime dependencies to the module/{@link Injector}.
	 * <p><p>
	 * Must be called before the new agent is instantiated with {@link Injector}.
	 * @param agentId
	 */
	public void newBindings(IAgentId agentId) {
		getAgentScope().clearScope();
		defConDependenciesProvider.
			set(new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add(agentId));
	}	
	
	@Override
	protected void configureModules() {
		super.configureModules();
		PogamutJBotSupport.writeToConsole("DefConAgentModule configure modules()");
		addModule(new AbstractModule() {

			@Override
			protected void configure() {				
				bind(IAgent.class).to(IObservingAgent.class);
				bind(IObservingAgent.class).to(IEmbodiedAgent.class);
				bind(IEmbodiedAgent.class).to(IDefConAgent.class);
				bind(IDefConAgent.class).to(DefConAgent.class);
				if (DefConAgent.class != defConAgentClass)
					bind(DefConAgent.class).to(defConAgentClass);
				bind(IWorldView.class).to(DefConWorldView.class);		
				bind(IWorldChangeEventOutput.class).to(DefConMessageProducer.class);
				bind(IDefConAgentController.class).to(IDefConAgentLogicController.class);
				bind(IDefConAgentLogicController.class).to(defConAgentLogicControllerClass);
				bind(ComponentDependencies.class).
					annotatedWith(Names.named(DefConWorldView.WORLDVIEW_DEPENDENCY)).
					toProvider(defConDependenciesProvider);
			}
			
		});			
	}

}