package cz.cuni.amis.pogamut.defcon.utils.tests.qtree;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;

import javax.swing.JScrollPane;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTree;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTreeNode;

/**
 * Visualizes {@link cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTree}s and
 * underlying polygon.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class QuadTreeVisualizer extends JScrollPane {

	private QuadTree qTree;
	private List<Location> poly;
	private final static double FACTOR = 5d;

	/**
	 * Constructs the visualizer
	 * 
	 * @param qTree
	 * @param poly
	 */
	public QuadTreeVisualizer(QuadTree qTree, List<Location> poly) {
		super(VERTICAL_SCROLLBAR_ALWAYS, HORIZONTAL_SCROLLBAR_ALWAYS);
		this.qTree = qTree;
		this.poly = poly;
		setSize(1024, 768);
		setVisible(true);
	}

	@Override
	public void paint(Graphics g) {
		Graphics2D g2d = (Graphics2D) g;
		Color old_color = g2d.getBackground();

		g2d.setBackground(Color.WHITE);
		g2d.clearRect(0, 0, getWidth(), getHeight());
		g2d.setBackground(old_color);

		old_color = g2d.getColor();

		g2d.setColor(Color.GRAY);
		
		double offset_x = qTree.getRoot().getX1();
		double offset_y = qTree.getRoot().getY1();

		double max_x = qTree.getRoot().getX2();
		double max_y = qTree.getRoot().getY2();
		/*
		 * for (double i = 0; i < max_x - offset_x; ++i) { g2d.drawLine( (int)
		 * (i * FACTOR), 0, (int) (i * FACTOR), (int) ((max_y - offset_y) *
		 * FACTOR)); }
		 * 
		 * for (double j = 0; j < max_y - offset_y; ++j) { g2d.drawLine( 0,
		 * (int) (j * FACTOR), (int) ((max_x - offset_x) * FACTOR), (int) (j *
		 * FACTOR)); }
		 */
		g2d.setColor(Color.RED);

		for (QuadTreeNode node : qTree) {
			int width = (int) ((node.getX2() -
					node.getX1()) * FACTOR) - 4;
			int height = (int) ((node.getY2() -
					node.getY1()) * FACTOR) - 4;

			int x = (int) ((node.getX1() - offset_x) * FACTOR) + 2;
			int y = (int) ((node.getY1() - offset_y) * FACTOR) + 2;

			if (node.isLabeled()) {
				g2d.setColor(Color.GREEN);
			}

			g2d.drawRect(x, y, width, height);

			g2d.setColor(Color.RED);
		}

		g2d.setColor(Color.BLUE);

		Location last = poly.get(poly.size() - 1);
		for (Location node : poly) {

			int x1 = (int) ((last.getX() - offset_x) * FACTOR);
			int y1 = (int) ((last.getY() - offset_y) * FACTOR);
			int x2 = (int) ((node.getX() - offset_x) * FACTOR);
			int y2 = (int) ((node.getY() - offset_y) * FACTOR);

			g2d.drawLine(x1, y1, x2, y2);
			last = node;
		}

		g2d.setColor(Color.BLACK);
		g2d.drawRect(0, 0, 5, 5);
		g2d.drawRect(
				(int) ((max_x - offset_x) * FACTOR - 5),
				0,
				5,
				5);
		g2d.drawRect(
				0,
				(int) ((max_y - offset_y) * FACTOR - 5),
				5,
				5);
		g2d.drawRect(
				(int) ((max_x - offset_x) * FACTOR - 5),
				(int) ((max_y - offset_y) * FACTOR - 5),
				5,
				5);

		/*
		 * for (QuadTreeNode node : qTree) { int width = (int) ((node.getX2() -
		 * node.getX1())); int height = (int) ((node.getY2() - node.getY1()));
		 * 
		 * g2d.drawRect( (int) (node.getX1()), (int) (node.getY1()), width,
		 * height); }
		 * 
		 * g2d.setColor(Color.BLUE);
		 * 
		 * Location last = poly.get(poly.size() - 1); for (Location node : poly)
		 * { g2d.drawLine( (int) (last.getX()), (int) (last.getY()), (int)
		 * (node.getX()), (int) (node.getY())); last = node; }
		 */
		g2d.setColor(old_color);

		// super.paint(g);
	}
}
