package cz.cuni.amis.pogamut.defcon.utils.quadtree;

import java.util.NoSuchElementException;

/**
 * Quadtree iterator with a limited depth of access.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class DepthLimitedQuadTreePostorderIterator extends
		QuadTreePostorderIterator {

	private int maxDepth;

	/**
	 * Level 1 is root.
	 * 
	 * @param tree
	 * @param maxDepth
	 */
	public DepthLimitedQuadTreePostorderIterator(QuadTree tree, int maxDepth) {
		super(tree);

		if (maxDepth <= 0)
			throw new IllegalArgumentException(
					"maxDepth argument " + maxDepth + " cannot be <= 0.");

		this.maxDepth = maxDepth;
	}

	@Override
	public QuadTreeNode next() {

		if (getNode() == null) {
			if (isFinished() || getRoot() == null) {
				throw new NoSuchElementException(
						"No more elements in iterated QuadTree");
			} else {
				setNode(getRoot());

				while (getNode().getNodes() != null
						&& getBranching().size() < maxDepth) {
					setNode(getNode().getFirst());
					getBranching().add(0);
				}

				if (getNode() == getRoot()) {
					setFinished(true);
				}

				return getNode();
			}
		} // else node != null

		setNode(getNode().getParent());

		int next = getBranching().pollLast();

		if (next == 3) {

			if (getNode() == getRoot())
				setFinished(true);

			return getNode();
		} else {

			getBranching().add(++next);
			setNode(getNode().getNodes()[next]);

			while (getNode().getNodes() != null
					&& getBranching().size() < maxDepth) {
				setNode(getNode().getFirst());
				getBranching().add(0);
			}

			return getNode();
		}
	}

}
