package cz.cuni.amis.pogamut.defcon.agent.module.logic;

import java.util.logging.Logger;

import com.google.inject.Inject;

import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.agent.module.LogicModule;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.defcon.agent.DefConAgent;

/**
 * Defcon logic module.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 * @param <AGENT>
 */
public class DefConAgentLogic<AGENT extends DefConAgent> extends LogicModule<AGENT> {

	@Inject
	public DefConAgentLogic(AGENT agent, IAgentLogic<LogicModule<AGENT>> logic) {
		this(agent, logic, null, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add(agent.getWorldView()));
	}
	
	public DefConAgentLogic(AGENT agent, IAgentLogic<LogicModule<AGENT>> logic, Logger log) {
		this(agent, logic, log, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add(agent.getWorldView()));
	}
	
	public DefConAgentLogic(AGENT agent, IAgentLogic<LogicModule<AGENT>> logic, Logger log, ComponentDependencies dependencies) {
		super(agent, logic, log, dependencies);
	}
	
	@Override
	protected void beforeLogic(String threadName) {
		agent.getWorldView().update();
	}

	@Override
	protected void afterLogic(String threadName) {
	}
	
}
