package cz.cuni.amis.pogamut.defcon.utils.quadtree;

/**
 * Width limited iterator only accesses nodes of a minimum side.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class WidthLimitedQuadTreePostorderIterator extends
		DepthLimitedQuadTreePostorderIterator {

	public WidthLimitedQuadTreePostorderIterator(QuadTree tree, double minWidth) {
		super(tree, getDepth(minWidth, tree.getRoot().getSize()));
	}

	private final static int getDepth(double minWidth, double size) {

		if (minWidth > size) {
			throw new IllegalArgumentException(
					"minWidth argument " + minWidth +
							" cannot be > tree size " + size + ". ");
		}

		double tmp = size / minWidth;

		tmp = Math.ceil(Math.log(tmp) / Math.log(2));

		return (int) tmp;
	}

}
