package cz.cuni.amis.pogamut.defcon.utils;

import java.util.LinkedList;

/**
 * Simple flag monitoring changes in a value.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 * @param <T>
 */
public class SimpleFlag<T> {
	private LinkedList<AdvancedFlagListener<T>> listeners = new LinkedList<AdvancedFlagListener<T>>();
	
	private T value;

	public void addStrongListener(AdvancedFlagListener<T> listener) {
		listeners.addLast(listener);
	}

	public void clearListeners() {
		listeners.clear();
	}

	public T getFlag() {
		return value;
	}

	public void removeListener(AdvancedFlagListener<T> listener) {
		listeners.remove(listener);
	}

	public void setFlag(T newValue) {
		if (newValue == value)
			return;
		
		T oldValue = value;
		value = newValue;
		
		for (AdvancedFlagListener<T> listener : listeners) {
			listener.flagChanged(oldValue, newValue);
		}
	}
	
	public SimpleFlag(T value) {
		this.value = value;
	}
}
