package cz.cuni.amis.pogamut.defcon.consts.state;

import java.util.HashMap;
import java.util.Map;

import javabot.JBot;

/**
 * Contains all states for Silo.
 * 
 * @author Radek 'Black_Hand' Pibil
 *
 */
public enum SiloState implements IState {
	
	NUKE(JBot.STATE_SILONUKE),        
    AIR_DEFENSE(JBot.STATE_SILOAIRDEFENSE);
	
	private static Map<Integer, SiloState> states = new HashMap<Integer, SiloState>();
	
	public static SiloState getState(int stateId) {
		return states.get(stateId);
	}
	
	static {
		for (SiloState state : SiloState.values()) {
			states.put(state.getStateId(), state);
		}
	}	
	
	public final int id;
	
	private SiloState(int id) {
		this.id = id;
	}

	@Override
	public int getStateId() {
		return id;
	}	

	@Override
	public Enum<? extends IState> getEnum() {
		return this;
	}

}
