package cz.cuni.amis.pogamut.defcon.agent;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;

import javabot.PogamutJBotSupport;
import cz.cuni.amis.pogamut.base.utils.logging.LogPublisher;

public class DefConLogPublisher extends LogPublisher {
	
	private static class DefConLogFormatter extends Formatter {

		@Override
		public String format(LogRecord record) {
			return "[" + record.getLevel() + "] " + record.getMessage();
		}
		
	}
	
	public DefConLogPublisher() {
		formatter = new DefConLogFormatter();
	}
	
	public DefConLogPublisher(Formatter formatter) {
		this.formatter = formatter;
	}

	@Override
	public void close() throws SecurityException {
	}

	@Override
	public void flush() {
	}

	@Override
	public void publish(LogRecord record, String formattedMsg) {
		if (formattedMsg != null && PogamutJBotSupport.botIsRunning.getFlag()) {
			PogamutJBotSupport.writeToConsole(formattedMsg);
		}
	}

}
