/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging;

import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.PogamutProperty;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.NetworkLogEnvelope;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutIOException;
import cz.cuni.amis.utils.maps.LazyMap;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetworkLogManager {
    private static final int MAXIMUM_LOGS_PER_AGENT = 100;
    public static final Charset USED_CHARSET = Charset.forName("UTF-8");
    public static final long NETWORK_FLUSH_PERIOD_MILLIS = 200L;
    public static final long NETWORK_LOG_MANAGER_SOCKET_TIMEOUT_MILLIS = 1000L;
    private static NetworkLogManager manager = null;
    private static Object managerMutex = new Object();
    private static LogCategory log = new LogCategory("NetworkLogManager");
    private Object serverWorkerMutex = new Object();
    private LazyMap<IToken, ConcurrentLinkedQueue<LogSocket>> idToSocketList = new LazyMap<IToken, ConcurrentLinkedQueue<LogSocket>>(){

        protected ConcurrentLinkedQueue<LogSocket> create(IToken key) {
            return new ConcurrentLinkedQueue<LogSocket>();
        }
    };
    private LazyMap<IToken, ConcurrentLinkedQueue<NetworkLogEnvelope>> idToEnvelopeList = new LazyMap<IToken, ConcurrentLinkedQueue<NetworkLogEnvelope>>(){

        protected ConcurrentLinkedQueue<NetworkLogEnvelope> create(IToken key) {
            return new ConcurrentLinkedQueue<NetworkLogEnvelope>();
        }
    };
    private boolean operating = true;
    protected ServerWorker serverWorker = null;
    protected Thread serverWorkerThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkLogManager getNetworkLogManager() {
        NetworkLogManager instance = manager;
        if (instance != null && instance.operating) {
            return instance;
        }
        Object object = managerMutex;
        synchronized (object) {
            instance = manager;
            if (instance == null || !instance.operating) {
                manager = instance = new NetworkLogManager();
            }
            return instance;
        }
    }

    private NetworkLogManager() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        Object object = this.serverWorkerMutex;
        synchronized (object) {
            if (log != null && log.isLoggable(Level.FINER)) {
                log.finer("Starting...");
            }
            try {
                this.serverWorker = new ServerWorker();
            }
            catch (IOException e) {
                throw new PogamutIOException("Could not initialize NetworkLogManager, could not open server socket.", (Throwable)e, (Logger)log, (Object)this);
            }
            this.serverWorkerThread = new Thread((Runnable)this.serverWorker, "NetworkLogManager-ServerSocket");
            this.serverWorkerThread.start();
            log.fine("Started.");
        }
    }

    public boolean isRunning() {
        return this.operating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        this.operating = false;
        Object object = managerMutex;
        synchronized (object) {
            if (manager == this) {
                manager = null;
            }
        }
        if (log != null && log.isLoggable(Level.WARNING)) {
            log.warning("Shutting down!");
        }
        object = this.serverWorkerMutex;
        synchronized (object) {
            this.serverWorker.kill();
            this.serverWorker = null;
            while (this.idToSocketList.size() > 0) {
                IToken agent;
                LazyMap<IToken, ConcurrentLinkedQueue<LogSocket>> lazyMap = this.idToSocketList;
                synchronized (lazyMap) {
                    if (this.idToSocketList.size() == 0) {
                        break;
                    }
                    agent = (IToken)this.idToSocketList.keySet().iterator().next();
                }
                this.removeAgent(agent);
            }
            log.severe("Shutdown.");
        }
    }

    public int getLoggerPort() {
        if (!this.operating) {
            return -1;
        }
        ServerWorker serverWorker = this.serverWorker;
        if (serverWorker == null) {
            return -1;
        }
        return serverWorker.serverSocket.getLocalPort();
    }

    public String getLoggerHost() {
        if (!this.operating) {
            return null;
        }
        if (this.serverWorker == null) {
            return null;
        }
        try {
            byte[] addr = InetAddress.getLocalHost().getAddress();
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new PogamutException("Could not determine host IP address.", (Throwable)e, (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAgent(IToken agent) {
        if (!this.operating) {
            return;
        }
        if (log != null && log.isLoggable(Level.FINE)) {
            log.fine("Adding network logging for agent: " + agent.getToken());
        }
        Object object = this.idToSocketList;
        synchronized (object) {
            this.idToSocketList.get((Object)agent);
        }
        object = this.idToEnvelopeList;
        synchronized (object) {
            this.idToEnvelopeList.get((Object)agent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAgent(IToken agent) {
        ConcurrentLinkedQueue agentSockets;
        if (log != null && log.isLoggable(Level.WARNING)) {
            log.warning("Removing network logging for agent: " + agent);
        }
        if (log != null && log.isLoggable(Level.INFO)) {
            log.info("Closing logging sockets for: " + agent);
        }
        Object object = this.idToSocketList;
        synchronized (object) {
            agentSockets = (ConcurrentLinkedQueue)this.idToSocketList.get((Object)agent);
            this.idToSocketList.remove((Object)agent);
        }
        object = agentSockets.iterator();
        while (object.hasNext()) {
            LogSocket socket;
            LogSocket logSocket = socket = (LogSocket)object.next();
            synchronized (logSocket) {
                try {
                    socket.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                socket.close();
            }
        }
        log.info("Removing bruffered logs for: " + agent);
        object = this.idToEnvelopeList;
        synchronized (object) {
            this.idToEnvelopeList.remove((Object)agent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLog(NetworkLogEnvelope record, IToken agent) {
        ConcurrentLinkedQueue agentLogs;
        if (!this.operating) {
            return;
        }
        if (log != null && log.isLoggable(Level.FINEST)) {
            log.finest("Processing log: (" + agent.getToken() + ") " + record);
        }
        ConcurrentLinkedQueue agentSockets = null;
        Object object = this.idToSocketList;
        synchronized (object) {
            if (this.idToSocketList.containsKey((Object)agent)) {
                agentSockets = (ConcurrentLinkedQueue)this.idToSocketList.get((Object)agent);
            }
        }
        if (agentSockets != null) {
            Iterator iter = agentSockets.iterator();
            while (iter.hasNext()) {
                LogSocket logSocket;
                LogSocket logSocket2 = logSocket = (LogSocket)iter.next();
                synchronized (logSocket2) {
                    if (!logSocket.isOpened()) {
                        logSocket.close();
                        iter.remove();
                        continue;
                    }
                    try {
                        logSocket.send(record);
                    }
                    catch (Exception e) {
                        logSocket.close();
                        iter.remove();
                    }
                }
            }
        }
        object = this.idToEnvelopeList;
        synchronized (object) {
            agentLogs = (ConcurrentLinkedQueue)this.idToEnvelopeList.get((Object)agent);
        }
        agentLogs.add(record);
        while (agentLogs.size() > 100) {
            try {
                agentLogs.remove();
            }
            catch (Exception exception) {}
        }
    }

    public static LogCategory getLog() {
        return log;
    }

    static {
        String level = Pogamut.getPlatform().getProperty(PogamutProperty.POGAMUT_NETWORK_LOG_MANAGER_AND_CLIENT_LEVEL.getKey());
        if (level == null) {
            level = "WARNING";
        }
        log.setLevel(Level.parse(level));
        log.addConsoleHandler();
    }

    private class ServerWorker
    implements Runnable {
        private ServerSocket serverSocket;
        private volatile boolean shouldRun = true;
        private volatile boolean running = false;
        private volatile boolean exceptionExpected = false;
        private Thread myThread;
        private List<DanglingSocket> danglingSockets = new LinkedList<DanglingSocket>();

        public ServerWorker() throws IOException {
            this.serverSocket = new ServerSocket();
            this.serverSocket.bind(new InetSocketAddress(0));
        }

        public void kill() {
            if (!this.running) {
                return;
            }
            this.shouldRun = false;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.exceptionExpected = true;
            this.myThread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block49: {
                this.myThread = Thread.currentThread();
                this.running = true;
                if (log != null && log.isLoggable(Level.INFO)) {
                    log.info("ServerWorker started.");
                }
                while (NetworkLogManager.this.operating && this.shouldRun && !this.myThread.isInterrupted()) {
                    try {
                        Socket socket = null;
                        if (this.danglingSockets.size() == 0) {
                            socket = this.serverSocket.accept();
                        } else {
                            this.serverSocket.setSoTimeout(100);
                            try {
                                socket = this.serverSocket.accept();
                            }
                            catch (SocketTimeoutException socketTimeoutException) {
                                // empty catch block
                            }
                        }
                        if (socket != null) {
                            log.fine("Accepted new connection from " + socket.getRemoteSocketAddress());
                            try {
                                this.danglingSockets.add(new DanglingSocket(socket));
                            }
                            catch (IOException e1) {
                                try {
                                    socket.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        Iterator<DanglingSocket> iter = this.danglingSockets.iterator();
                        while (iter.hasNext()) {
                            DanglingSocket danglingSocket = iter.next();
                            String agentId = danglingSocket.readAgentId();
                            if (agentId != null) {
                                LogSocket logSocket;
                                Iterator iter2;
                                Token token = Tokens.get((String)agentId);
                                log.fine("Connection " + danglingSocket.socket.getRemoteSocketAddress() + " sent agent id '" + token.getToken() + "'.");
                                LazyMap lazyMap = NetworkLogManager.this.idToEnvelopeList;
                                synchronized (lazyMap) {
                                    ConcurrentLinkedQueue queue = (ConcurrentLinkedQueue)NetworkLogManager.this.idToEnvelopeList.get((Object)token);
                                    int size = queue.size();
                                    log.finer("Sending buffered " + size + " log records to the " + danglingSocket.socket.getRemoteSocketAddress());
                                    iter2 = queue.iterator();
                                }
                                LogSocket logSocket2 = logSocket = new LogSocket(danglingSocket.socket);
                                synchronized (logSocket2) {
                                    LazyMap size = NetworkLogManager.this.idToSocketList;
                                    synchronized (size) {
                                        ((ConcurrentLinkedQueue)NetworkLogManager.this.idToSocketList.get((Object)token)).add(logSocket);
                                    }
                                    while (iter2.hasNext()) {
                                        NetworkLogEnvelope env = (NetworkLogEnvelope)iter2.next();
                                        logSocket.send(env);
                                    }
                                }
                                iter.remove();
                                continue;
                            }
                            if (System.currentTimeMillis() - danglingSocket.created >= 1000L) continue;
                            log.warning("Connection " + danglingSocket.socket.getRemoteSocketAddress() + " timed out. We did not receive agent id in " + 1000L + " ms. Closing the socket.");
                            try {
                                danglingSocket.socket.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            iter.remove();
                        }
                    }
                    catch (Exception e) {
                        if (!this.exceptionExpected) {
                            log.severe(ExceptionToString.process((String)"Exception at ServerWorker.", (Throwable)e));
                            continue;
                        }
                        log.fine(ExceptionToString.process((String)"Exception at ServerWorker, expected.", (Throwable)e));
                        break;
                    }
                }
                this.running = false;
                for (DanglingSocket socket : this.danglingSockets) {
                    try {
                        socket.socket.close();
                    }
                    catch (Exception exception) {}
                }
                this.danglingSockets.clear();
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {}
                break block49;
                catch (Exception e) {
                    if (!this.exceptionExpected) {
                        log.severe(ExceptionToString.process((String)"Exception at ServerWorker.", (Throwable)e));
                    } else {
                        log.fine(ExceptionToString.process((String)"Exception ServerWorker, expected.", (Throwable)e));
                    }
                    this.running = false;
                    for (DanglingSocket socket : this.danglingSockets) {
                        try {
                            socket.socket.close();
                        }
                        catch (Exception exception) {}
                    }
                    this.danglingSockets.clear();
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException iOException) {}
                    catch (Throwable throwable) {
                        this.running = false;
                        for (DanglingSocket socket : this.danglingSockets) {
                            try {
                                socket.socket.close();
                            }
                            catch (Exception exception) {}
                        }
                        this.danglingSockets.clear();
                        try {
                            this.serverSocket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            log.warning("ServerWorker Stopped.");
        }
    }

    private class DanglingSocket {
        CharsetEncoder encoder = USED_CHARSET.newEncoder();
        CharsetDecoder decoder = USED_CHARSET.newDecoder();
        public Socket socket;
        public final long created = System.currentTimeMillis();
        private PrintWriter writer;
        private BufferedReader reader;
        private StringBuffer agentId = new StringBuffer();
        private char[] buf = new char[128];

        public DanglingSocket(Socket socket) throws IOException {
            this.socket = socket;
            this.writer = new PrintWriter(socket.getOutputStream());
            this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }

        public String readAgentId() throws IOException {
            int read = this.reader.read(this.buf);
            if (read == 0) {
                return null;
            }
            if (this.buf[read - 1] == '\n') {
                int minus = 1;
                if (read > 1 && this.buf[read - 2] == '\r') {
                    minus = 2;
                }
                this.agentId.append(this.buf, 0, read - minus);
                return this.agentId.toString();
            }
            this.agentId.append(this.buf, 0, read);
            return null;
        }
    }

    private static class LogSocket {
        public CharsetEncoder encoder = USED_CHARSET.newEncoder();
        private Socket socket;
        private boolean opened = true;
        private PrintWriter writer;
        private long lastFlush = System.currentTimeMillis();

        public LogSocket(Socket socket) throws IOException {
            this.socket = socket;
            this.writer = new PrintWriter(new OutputStreamWriter(socket.getOutputStream(), this.encoder));
        }

        public boolean isOpened() {
            return this.opened;
        }

        public void close() {
            if (!this.opened) {
                return;
            }
            this.opened = false;
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.encoder = null;
            this.writer = null;
            this.socket = null;
        }

        public void send(NetworkLogEnvelope log) throws IOException {
            this.writer.println(log.getCategory());
            this.writer.println(log.getLevel());
            this.writer.println(String.valueOf(log.getMillis()));
            this.writer.println(log.getMessage());
            this.writer.println("</end>");
            this.checkFlush();
        }

        public void flush() throws IOException {
            this.writer.flush();
            this.lastFlush = System.currentTimeMillis();
        }

        public void checkFlush() throws IOException {
            if (System.currentTimeMillis() - this.lastFlush > 200L) {
                this.flush();
            }
        }
    }
}

