/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.module.comm;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.Tuple2;
import cz.cuni.amis.utils.maps.HashMapSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PogamutJVMComm {
    protected static Object instanceMutex = new Object();
    protected static PogamutJVMComm instance;
    protected static ConcurrentLinkedQueue<PogamutJVMComm> comms;
    public static final int ALL_CHANNELS = -1;
    protected Map<IAgentId, Tuple2<IObservingAgent, Integer>> registeredAgents = new HashMap<IAgentId, Tuple2<IObservingAgent, Integer>>();
    protected Set<IObservingAgent> allChannels = new HashSet<IObservingAgent>();
    protected HashMapSet<Integer, IObservingAgent> channels = new HashMapSet();
    protected ReadWriteLock lock = new ReentrantReadWriteLock(true);
    protected Lock readLock = this.lock.readLock();
    protected Lock writeLock = this.lock.writeLock();
    protected Logger log;
    protected Object executorMutex = new Object();
    protected ThreadPoolExecutor executor = null;
    protected Object numberOfRegisterAgentPendingMutex = new Object();
    protected int numberOfRegisterAgentPending = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PogamutJVMComm getInstance() {
        if (instance == null) {
            Object object = instanceMutex;
            synchronized (object) {
                if (instance == null) {
                    instance = new PogamutJVMComm();
                    ((LogCategory)instance.getLog()).addConsoleHandler();
                    instance.getLog().setLevel(Level.INFO);
                }
            }
        }
        return instance;
    }

    public static void platformClose() {
        while (comms.size() > 0) {
            comms.poll().destroy();
        }
    }

    public PogamutJVMComm() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PogamutJVMComm(Logger log) {
        this.log = log;
        ConcurrentLinkedQueue<PogamutJVMComm> concurrentLinkedQueue = comms;
        synchronized (concurrentLinkedQueue) {
            if (this.log == null) {
                this.log = new LogCategory("AgentJVMComm" + comms.size());
            }
            comms.add(this);
        }
    }

    public Logger getLog() {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int incRegisteredAgent(IObservingAgent agent) {
        Map<IAgentId, Tuple2<IObservingAgent, Integer>> map = this.registeredAgents;
        synchronized (map) {
            Tuple2 record = this.registeredAgents.get(agent.getComponentId());
            if (record == null) {
                record = new Tuple2((Object)agent, (Object)0);
                this.registeredAgents.put(agent.getComponentId(), (Tuple2<IObservingAgent, Integer>)record);
            }
            if (record.getFirst() != agent) {
                throw new RuntimeException("agent.getComponentId() clash! Under " + agent.getComponentId() + " is registered agent " + record.getFirst() + " NOT AGENT " + agent + ".");
            }
            record.setSecond((Object)((Integer)record.getSecond() + 1));
            return (Integer)record.getSecond();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int decRegisteredAgent(IObservingAgent agent) {
        Map<IAgentId, Tuple2<IObservingAgent, Integer>> map = this.registeredAgents;
        synchronized (map) {
            Tuple2<IObservingAgent, Integer> record = this.registeredAgents.get(agent.getComponentId());
            if (record == null) {
                throw new RuntimeException("Attempt to decrease registration count for agent that is not registered, agent.getComponentId() == " + agent.getComponentId() + ".");
            }
            record.setSecond((Object)((Integer)record.getSecond() - 1));
            if ((Integer)record.getSecond() == 0) {
                this.registeredAgents.remove(agent.getComponentId());
            }
            return (Integer)record.getSecond();
        }
    }

    public void registerAgent(IObservingAgent agent, int channel) {
        if (channel < 0 && channel != -1) {
            throw new RuntimeException("channel == " + channel + " < 0, INVALID");
        }
        if (this.writeLock.tryLock()) {
            try {
                this.registerAgentUnsyncImpl(agent, channel);
            }
            finally {
                this.writeLock.unlock();
            }
        } else {
            this.execute(new RegisterAgent(agent, channel), true);
        }
    }

    protected void registerAgentSyncImpl(IObservingAgent agent, int channel) {
        this.writeLock.lock();
        try {
            this.registerAgentUnsyncImpl(agent, channel);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void registerAgentUnsyncImpl(IObservingAgent agent, int channel) {
        if (channel == -1) {
            if (this.allChannels.contains(agent)) {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Agent " + agent.getComponentId() + " is already registered for ALL_CHANNELS (ignoring this request).");
                }
                return;
            }
            this.allChannels.add(agent);
        } else {
            if (this.channels.get((Object)channel).contains(agent)) {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Agent " + agent.getComponentId() + " is already registered for channel " + channel + " (ignoring this request).");
                }
                return;
            }
            this.channels.add((Object)channel, (Object)agent);
        }
        int registerCount = this.incRegisteredAgent(agent);
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info("Registered " + agent.getComponentId() + " for " + (channel == -1 ? "ALL_CHANNELS" : "channel " + channel) + ". Agent is registered " + registerCount + "x (in total).");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAgentRegistered(IObservingAgent agent, int channel) {
        if (channel < 0 && channel != -1) {
            throw new RuntimeException("channel == " + channel + " < 0, INVALID");
        }
        this.readLock.lock();
        try {
            if (channel == -1) {
                boolean bl = this.allChannels.contains(agent);
                return bl;
            }
            boolean bl = this.getChannel(channel).contains(agent);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<IObservingAgent> getChannel(int channel) {
        if (channel == -1) {
            return this.allChannels;
        }
        if (this.channels.containsKey((Object)channel)) {
            return this.channels.get((Object)channel);
        }
        HashMapSet<Integer, IObservingAgent> hashMapSet = this.channels;
        synchronized (hashMapSet) {
            return this.channels.get((Object)channel);
        }
    }

    public void unregisterAgent(IObservingAgent agent, int channel) {
        if (channel < 0 && channel != -1) {
            throw new RuntimeException("channel == " + channel + " < 0, INVALID");
        }
        if (this.writeLock.tryLock()) {
            try {
                this.unregisterAgentUnsyncImpl(agent, channel);
            }
            finally {
                this.writeLock.unlock();
            }
        } else {
            this.execute(new UnregisterAgentFromChannel(agent, channel), false);
        }
    }

    protected void unregisterAgentSyncImpl(IObservingAgent agent, int channel) {
        this.writeLock.lock();
        try {
            this.unregisterAgentUnsyncImpl(agent, channel);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void unregisterAgentUnsyncImpl(IObservingAgent agent, int channel) {
        if (channel == -1) {
            if (this.allChannels.remove(agent)) {
                int registerCount = this.decRegisteredAgent(agent);
                if (this.log != null && this.log.isLoggable(Level.INFO)) {
                    this.log.info("UNregistered " + agent.getComponentId() + " from ALL_CHANNELS. " + (registerCount == 0 ? "Agent is now fully UNREGISTERED." : "Agent remains registered for other channels (" + registerCount + "x in total)."));
                }
                if (this.registeredAgents.size() == 0) {
                    this.shutdown(false);
                }
            }
        } else if (this.getChannel(channel).remove(agent)) {
            int registerCount = this.decRegisteredAgent(agent);
            if (this.log != null && this.log.isLoggable(Level.INFO)) {
                this.log.info("UNregistered " + agent.getComponentId() + " from channel " + channel + ". " + (registerCount == 0 ? "Agent is now fully UNREGISTERED." : "Agent remains registered for other channels (" + registerCount + "x in total)."));
            }
            if (this.registeredAgents.size() == 0) {
                this.shutdown(false);
            }
        }
    }

    public void unregisterAgent(IObservingAgent agent) {
        if (this.writeLock.tryLock()) {
            try {
                this.unregisterAgentUnsyncImpl(agent);
            }
            finally {
                this.writeLock.unlock();
            }
        } else {
            this.execute(new UnregisterAgent(agent), false);
        }
    }

    protected void unregisterAgentSyncImpl(IObservingAgent agent) {
        this.writeLock.lock();
        try {
            this.unregisterAgentUnsyncImpl(agent);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterAgentUnsyncImpl(IObservingAgent agent) {
        HashMapSet<Integer, IObservingAgent> hashMapSet = this.channels;
        synchronized (hashMapSet) {
            for (Integer channel : this.channels.keySet()) {
                this.unregisterAgentUnsyncImpl(agent, channel);
            }
        }
        this.unregisterAgentUnsyncImpl(agent, -1);
    }

    public void send(IWorldChangeEvent event, int channel) {
        this.execute(new Send(event, channel), false);
    }

    public void sendToOthers(IWorldChangeEvent event, int channel, IObservingAgent sender) {
        this.execute(new SendToOthers(event, channel, sender), false);
    }

    protected void sendSyncImpl(IWorldChangeEvent event, int channel) {
        this.readLock.lock();
        try {
            this.sendUnsyncImpl(event, channel);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendToOthersSyncImpl(IWorldChangeEvent event, int channel, IObservingAgent sender) {
        this.readLock.lock();
        try {
            this.sendToOthersUnsyncImpl(event, channel, sender);
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected void sendUnsyncImpl(IWorldChangeEvent event, int channel) {
        if (channel == -1) {
            this.broadcastUnsyncImpl(event);
        } else {
            for (IObservingAgent agent : this.getChannel(channel)) {
                this.sendToAgentUnsyncImpl(agent, event);
            }
            for (IObservingAgent agent : this.allChannels) {
                this.sendToAgentUnsyncImpl(agent, event);
            }
        }
    }

    protected void sendToOthersUnsyncImpl(IWorldChangeEvent event, int channel, IObservingAgent sender) {
        if (channel == -1) {
            this.broadcastToOthersUnsyncImpl(event, sender);
        } else {
            for (IObservingAgent agent : this.getChannel(channel)) {
                if (agent == sender) continue;
                this.sendToAgentUnsyncImpl(agent, event);
            }
            for (IObservingAgent agent : this.allChannels) {
                if (agent == sender) continue;
                this.sendToAgentUnsyncImpl(agent, event);
            }
        }
    }

    protected void sendToAgentUnsyncImpl(IObservingAgent agent, IWorldChangeEvent event) {
        block5: {
            try {
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine(event + " -> " + agent.getComponentId());
                }
                agent.getWorldView().notify(event);
            }
            catch (ComponentNotRunningException e1) {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Agent " + agent.getComponentId() + " is not running, did not receive: " + event);
                }
            }
            catch (Exception e2) {
                if (this.log == null || !this.log.isLoggable(Level.WARNING)) break block5;
                this.log.warning(ExceptionToString.process((String)("Agent " + agent.getComponentId() + " failed to process " + event + "."), (Throwable)e2));
            }
        }
    }

    public void broadcast(IWorldChangeEvent event) {
        this.execute(new Broadcast(event), false);
    }

    public void broadcastToOthers(IWorldChangeEvent event, IObservingAgent sender) {
        if (sender == null) {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("broadcast(event, null) called, sender unspecified");
            }
            this.broadcast(event);
        } else {
            this.execute(new BroadcastToOthers(event, sender), false);
        }
    }

    protected void broadcastSyncImpl(IWorldChangeEvent event) {
        this.readLock.lock();
        try {
            this.broadcastUnsyncImpl(event);
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected void broadcastToOthersSyncImpl(IWorldChangeEvent event, IObservingAgent sender) {
        this.readLock.lock();
        try {
            this.broadcastToOthersUnsyncImpl(event, sender);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastUnsyncImpl(IWorldChangeEvent event) {
        ArrayList existingChannels;
        HashMapSet<Integer, IObservingAgent> hashMapSet = this.channels;
        synchronized (hashMapSet) {
            existingChannels = new ArrayList(this.channels.keySet());
        }
        for (Integer channel : existingChannels) {
            for (IObservingAgent agent : this.getChannel(channel)) {
                this.sendToAgentUnsyncImpl(agent, event);
            }
        }
        for (IObservingAgent agent : this.allChannels) {
            this.sendToAgentUnsyncImpl(agent, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastToOthersUnsyncImpl(IWorldChangeEvent event, IObservingAgent sender) {
        ArrayList existingChannels;
        HashMapSet<Integer, IObservingAgent> hashMapSet = this.channels;
        synchronized (hashMapSet) {
            existingChannels = new ArrayList(this.channels.keySet());
        }
        for (Integer channel : existingChannels) {
            for (IObservingAgent agent : this.getChannel(channel)) {
                if (agent == sender) continue;
                this.sendToAgentUnsyncImpl(agent, event);
            }
        }
        for (IObservingAgent agent : this.allChannels) {
            if (agent == sender) continue;
            this.sendToAgentUnsyncImpl(agent, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        block61: {
            try {
                try {
                    this.shutdown(true);
                }
                finally {
                    Object object;
                    try {
                        object = this.channels;
                        synchronized (object) {
                            this.channels.clear();
                        }
                    }
                    finally {
                        try {
                            object = this.allChannels;
                            synchronized (object) {
                                this.allChannels.clear();
                            }
                        }
                        finally {
                            object = this.registeredAgents;
                            synchronized (object) {
                                this.registeredAgents.clear();
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                if (this.log == null || !this.log.isLoggable(Level.WARNING)) break block61;
                this.log.warning(ExceptionToString.process((String)"Failed to fully PogamutJVMComm.destroy().", (Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Runnable job, boolean forceStart) {
        if (this.executor == null) {
            Object object = this.executorMutex;
            synchronized (object) {
                if (this.executor == null && (forceStart || this.registeredAgents.size() > 0)) {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info("Starting thread pool executor.");
                    }
                    this.executor = new ThreadPoolExecutor(1, 20, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
                }
            }
        }
        if (this.executor == null) {
            return;
        }
        this.executor.execute(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown(boolean forced) {
        if (this.executor != null) {
            Object object = this.executorMutex;
            synchronized (object) {
                if (this.executor != null) {
                    block14: {
                        if (!forced) {
                            Object object2 = this.numberOfRegisterAgentPendingMutex;
                            synchronized (object2) {
                                if (this.numberOfRegisterAgentPending > 0) {
                                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                                        this.log.info("Won't shutdown thread pool executor, there are unprocessed agent-registration jobs in queue and shutdown is NOT forced.");
                                    }
                                    return;
                                }
                            }
                        }
                        if (this.log != null && this.log.isLoggable(Level.INFO)) {
                            this.log.info("Shutting down thread pool executor.");
                        }
                        try {
                            this.executor.shutdownNow();
                        }
                        catch (Exception e) {
                            if (this.log == null || !this.log.isLoggable(Level.WARNING)) break block14;
                            this.log.warning(ExceptionToString.process((String)"Error shutting down thread pool executor.", (Throwable)e));
                        }
                    }
                    this.executor = null;
                }
            }
        }
    }

    static {
        comms = new ConcurrentLinkedQueue();
    }

    protected class BroadcastToOthers
    implements Runnable {
        protected IWorldChangeEvent event;
        protected IObservingAgent sender;

        public BroadcastToOthers(IWorldChangeEvent event, IObservingAgent sender) {
            this.event = event;
            this.sender = sender;
        }

        @Override
        public void run() {
            PogamutJVMComm.this.broadcastToOthersSyncImpl(this.event, this.sender);
        }
    }

    protected class Broadcast
    implements Runnable {
        protected IWorldChangeEvent event;

        public Broadcast(IWorldChangeEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            PogamutJVMComm.this.broadcastSyncImpl(this.event);
        }
    }

    protected class SendToOthers
    implements Runnable {
        protected IWorldChangeEvent event;
        protected int channel;
        protected IObservingAgent sender;

        public SendToOthers(IWorldChangeEvent event, int channel, IObservingAgent sender) {
            this.event = event;
            this.channel = channel;
            this.sender = sender;
        }

        @Override
        public void run() {
            PogamutJVMComm.this.sendToOthersSyncImpl(this.event, this.channel, this.sender);
        }
    }

    protected class Send
    implements Runnable {
        protected IWorldChangeEvent event;
        protected int channel;

        public Send(IWorldChangeEvent event, int channel) {
            this.event = event;
            this.channel = channel;
        }

        @Override
        public void run() {
            PogamutJVMComm.this.sendSyncImpl(this.event, this.channel);
        }
    }

    protected class UnregisterAgent
    implements Runnable {
        protected IObservingAgent agent;

        public UnregisterAgent(IObservingAgent agent) {
            this.agent = agent;
        }

        @Override
        public void run() {
            PogamutJVMComm.this.unregisterAgentSyncImpl(this.agent);
        }
    }

    protected class UnregisterAgentFromChannel
    implements Runnable {
        protected IObservingAgent agent;
        protected int channel;

        public UnregisterAgentFromChannel(IObservingAgent agent, int channel) {
            this.agent = agent;
            this.channel = channel;
        }

        @Override
        public void run() {
            PogamutJVMComm.this.unregisterAgentSyncImpl(this.agent, this.channel);
        }
    }

    protected class RegisterAgent
    implements Runnable {
        protected IObservingAgent agent;
        protected int channel;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RegisterAgent(IObservingAgent agent, int channel) {
            Object object = PogamutJVMComm.this.numberOfRegisterAgentPendingMutex;
            synchronized (object) {
                ++PogamutJVMComm.this.numberOfRegisterAgentPending;
            }
            this.agent = agent;
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                PogamutJVMComm.this.registerAgentSyncImpl(this.agent, this.channel);
            }
            finally {
                Object object = PogamutJVMComm.this.numberOfRegisterAgentPendingMutex;
                synchronized (object) {
                    --PogamutJVMComm.this.numberOfRegisterAgentPending;
                }
            }
        }
    }
}

