/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.controller;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StartedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StartingEvent;
import cz.cuni.amis.pogamut.base.component.controller.ComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.ComponentController;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.controller.ComponentState;
import cz.cuni.amis.pogamut.base.component.controller.IComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.LifecycleBus;
import cz.cuni.amis.pogamut.base.component.stub.component.ManualCheckComponent;
import cz.cuni.amis.pogamut.base.component.stub.sharedcomponent.AutoCheckSharedComponent;
import cz.cuni.amis.pogamut.base.component.stub.sharedcomponent.EventToString;
import cz.cuni.amis.pogamut.base.component.stub.sharedcomponent.MethodToString;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.tests.BaseTest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Test;

public class Test18_SharedComponentController_StartWith
extends BaseTest {
    @Test
    public void test() {
        AgentId agentId1 = new AgentId("Test18_Shared-Agent1");
        AgentId agentId2 = new AgentId("Test18_Shared-Agent2");
        AgentLogger logger1 = new AgentLogger((IAgentId)agentId1);
        AgentLogger logger2 = new AgentLogger((IAgentId)agentId2);
        logger1.addDefaultConsoleHandler();
        logger1.setLevel(Level.ALL);
        logger2.addDefaultConsoleHandler();
        logger2.setLevel(Level.ALL);
        LifecycleBus bus1 = new LifecycleBus((IAgentLogger)logger1);
        LifecycleBus bus2 = new LifecycleBus((IAgentLogger)logger2);
        AutoCheckSharedComponent sharedComp = new AutoCheckSharedComponent((IAgentLogger)logger1);
        ManualCheckComponent manualComp1_0 = new ManualCheckComponent((IAgentLogger)logger1, (IComponentBus)bus1);
        ManualCheckComponent manualComp1_1 = new ManualCheckComponent((IAgentLogger)logger1, (IComponentBus)bus1);
        ManualCheckComponent manualComp2_2 = new ManualCheckComponent((IAgentLogger)logger2, (IComponentBus)bus2);
        ManualCheckComponent manualComp2_3 = new ManualCheckComponent((IAgentLogger)logger2, (IComponentBus)bus2);
        ComponentControlHelper emptyCtrl = new ComponentControlHelper();
        ComponentController manualCompCtrl1_0 = new ComponentController((IComponent)manualComp1_1, (IComponentControlHelper)emptyCtrl, (ILifecycleBus)bus1, (Logger)logger1.getCategory(manualComp1_1.getComponentId().getToken()), new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IComponent)manualComp1_0));
        ComponentController manualCompCtrl2 = new ComponentController((IComponent)manualComp2_3, (IComponentControlHelper)emptyCtrl, (ILifecycleBus)bus2, (Logger)logger2.getCategory(manualComp2_3.getComponentId().getToken()), new ComponentDependencies(ComponentDependencyType.STARTS_AFTER).add((IComponent)manualComp2_2));
        sharedComp.addComponentBus((IAgentId)agentId1, (ILifecycleBus)bus1, new ComponentDependencies(ComponentDependencyType.STARTS_AFTER).add((IComponent)manualComp1_1));
        sharedComp.addComponentBus((IAgentId)agentId2, (ILifecycleBus)bus2, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IComponent)manualComp2_3));
        sharedComp.expectExactOrder(EventToString.eventToString((IAgentId)agentId2, manualComp2_2, StartingEvent.class), EventToString.eventToString((IAgentId)agentId2, manualComp2_2, StartedEvent.class), EventToString.eventToString((IAgentId)agentId2, manualComp2_3, StartingEvent.class), MethodToString.preStart(sharedComp), MethodToString.start(sharedComp), MethodToString.localPreStart(sharedComp, (IAgentId)agentId2), EventToString.eventToString((IAgentId)agentId2, (IComponent)sharedComp, StartingEvent.class), MethodToString.localStart(sharedComp, (IAgentId)agentId2), EventToString.eventToString((IAgentId)agentId2, (IComponent)sharedComp, StartedEvent.class), EventToString.eventToString((IAgentId)agentId2, manualComp2_3, StartedEvent.class));
        manualComp2_2.manualStart();
        sharedComp.checkNoMoreActivityExpected();
        if (sharedComp.getController().notInState(new ComponentState[]{ComponentState.RUNNING})) {
            String msg = "[ERROR] " + sharedComp.getComponentId().getToken() + " is not in state RUNNING but in state " + sharedComp.getController().getState().getFlag() + ", INVALID!";
            System.out.println(msg);
            throw new RuntimeException(msg);
        }
        System.out.println("---/// TEST OK ///---");
    }
}

