/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.utils.timekey;

import cz.cuni.amis.pogamut.multi.utils.exception.TimeKeyNotLockedException;
import cz.cuni.amis.pogamut.multi.utils.timekey.ITimeKeyManager;
import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import java.util.HashSet;
import java.util.Random;
import org.junit.Ignore;

@Ignore
public class TimeKeyManagerTest
extends BaseTest {
    public static final int MAX_KEY_TO_LOCK = 100;
    protected boolean failure = false;

    protected void testTimeKeyManager(ITimeKeyManager timeKeyManager, int threadCount, int runs, int keysPerRun) {
        Thread[] threads = new Thread[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            threads[i] = new Thread(new Locker(timeKeyManager, runs, keysPerRun, i));
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                throw new PogamutInterruptedException((Throwable)e, (Object)this);
            }
        }
        if (this.failure) {
            this.assertFail("There was a failure in the test!");
        }
        log.info("Locked: " + timeKeyManager.getHeldKeysStr());
        for (long l = -1000L; l < 1000L; ++l) {
            if (!timeKeyManager.isLocked(l)) continue;
            this.testFailed("TimeKey  " + l + " is still locked");
        }
        threads = null;
    }

    protected class Locker
    implements Runnable {
        private Random r = new Random(10L);
        private HashSet<Long> locks = new HashSet();
        private int keysPerRun;
        private int runs;
        private int id;
        private ITimeKeyManager timeKeyManager;

        public Locker(ITimeKeyManager timeKeyManager, int runs, int keysPerRun, int id) {
            this.id = id;
            this.timeKeyManager = timeKeyManager;
            this.runs = runs;
            this.keysPerRun = keysPerRun;
        }

        protected void makeLock(long l) {
            if (this.locks.contains(l)) {
                return;
            }
            this.timeKeyManager.lock(l);
            this.locks.add(l);
        }

        protected void removeLock(long l) {
            if (this.locks.remove(l)) {
                try {
                    this.timeKeyManager.unlock(l);
                }
                catch (TimeKeyNotLockedException e) {
                    TimeKeyManagerTest.this.failure = true;
                    log.severe("Trying to unlock not locked TimeKey : " + l);
                    throw new RuntimeException("Trying to unlock not locked TimeKey : " + l);
                }
            }
        }

        protected void checkLocks() {
            for (Long l : this.locks) {
                if (this.timeKeyManager.isLocked(l.longValue())) continue;
                TimeKeyManagerTest.this.failure = true;
                log.severe("TimeKey " + l + " should be locked, but is not!!!");
                throw new RuntimeException("TimeKey " + l + " should be locked, but is not!!!");
            }
        }

        protected void removeLocks() {
            while (this.locks.size() > 0) {
                this.removeLock(this.locks.iterator().next());
                this.checkLocks();
            }
        }

        @Override
        public void run() {
            while (this.runs > 0) {
                if (this.runs % 20 == 0) {
                    log.info("Thread " + this.id + ": " + this.runs + " runs remaining");
                }
                for (int i = 0; i < this.keysPerRun; ++i) {
                    this.makeLock(i);
                }
                this.checkLocks();
                this.removeLocks();
                --this.runs;
            }
            log.info("Thread " + this.id + " : Finished.");
        }
    }
}

