/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.worldview.stubs;

import cz.cuni.amis.pogamut.base.communication.exception.CommunicationException;
import cz.cuni.amis.pogamut.base.communication.mediator.IMediator;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldChangeEventInput;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.Job;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Tokens;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import junit.framework.Assert;

public class MediatorStub
implements IMediator {
    private static int num = 0;
    private Flag<Boolean> running = new Flag((Object)false);
    private BlockingQueue<IWorldChangeEvent> eventsQueue = new LinkedBlockingQueue<IWorldChangeEvent>();
    private LogCategory log;
    private IToken token;
    private IWorldChangeEventInput consumer;

    public MediatorStub(IAgentLogger log, IWorldChangeEvent[] events) {
        this.pushEvent(events);
        this.token = Tokens.get((String)("MediatorStub" + ++num));
        this.log = log.getCategory((IComponent)this);
    }

    public MediatorStub(IAgentLogger logger) {
        this.token = Tokens.get((String)("MediatorStub" + ++num));
        this.log = logger.getCategory((IComponent)this);
    }

    public int getEventQueueLength() {
        return this.eventsQueue.size();
    }

    public void pushEvent(IWorldChangeEvent event) {
        this.eventsQueue.add(event);
    }

    public void pushEvent(IWorldChangeEvent[] events) {
        this.eventsQueue.addAll(MyCollections.toList((Object[])events));
    }

    public void clearEventsQueue() {
        if (this.log.isLoggable(Level.WARNING)) {
            this.log.warning("clearing events queue");
        }
        this.eventsQueue.clear();
    }

    public ImmutableFlag<Boolean> getRunning() {
        return this.running.getImmutable();
    }

    public void setConsumer(IWorldChangeEventInput consumer) {
        this.consumer = consumer;
    }

    public IToken getComponentId() {
        return this.token;
    }

    public LogCategory getLog() {
        return this.log;
    }

    public void kill() {
        this.running.setFlag((Object)false);
    }

    public void start() throws CommunicationException {
        this.running.setFlag((Object)true);
        new Job(){

            protected void job() throws Exception {
                try {
                    while (MediatorStub.this.eventsQueue.size() > 0) {
                        if (!((Boolean)MediatorStub.this.running.getFlag()).booleanValue()) {
                            if (!MediatorStub.this.log.isLoggable(Level.WARNING)) break;
                            MediatorStub.this.log.warning("Me: Stop requested, stopping mediator.");
                            break;
                        }
                        IWorldChangeEvent event = (IWorldChangeEvent)MediatorStub.this.eventsQueue.poll(100L, TimeUnit.MILLISECONDS);
                        if (!((Boolean)MediatorStub.this.running.getFlag()).booleanValue()) {
                            if (!MediatorStub.this.log.isLoggable(Level.WARNING)) break;
                            MediatorStub.this.log.warning("Me: Stop requested, stopping mediator.");
                            break;
                        }
                        if (event == null) continue;
                        if (MediatorStub.this.log.isLoggable(Level.INFO)) {
                            MediatorStub.this.log.info("event " + event);
                        }
                        MediatorStub.this.consumer.notify(event);
                    }
                    MediatorStub.this.stop();
                    MediatorStub.this.clearEventsQueue();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)"WorldView failed to process event...");
                }
            }
        }.startJob();
    }

    public void stop() {
        this.running.setFlag((Object)false);
    }
}

