/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.utils.runner;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStatePaused;
import cz.cuni.amis.pogamut.base.agent.utils.runner.IAgentDescriptor;
import cz.cuni.amis.pogamut.base.agent.utils.runner.IMultipleAgentRunner;
import cz.cuni.amis.pogamut.base.agent.utils.runner.impl.AgentDescriptor;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgent1;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgent1Module;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgent2;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgent2Module;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgentParams;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestMultipleAgentRunner;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentModule;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.List;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.Test;

public class Test13_MultipleAgentRunner_PausingBehavior
extends BaseTest {
    protected int preInitHookCalled = 0;
    protected int preStartHookCalled = 0;
    protected int postStartHookCalled = 0;
    protected int postStartedHookCalled = 0;
    protected int preResumeHookCalled = 0;

    @AfterClass
    public static void tearDown() {
        Pogamut.getPlatform().close();
    }

    protected IMultipleAgentRunner initMultipleAgentRunner() {
        this.preInitHookCalled = 0;
        this.preStartHookCalled = 0;
        this.postStartHookCalled = 0;
        this.postStartedHookCalled = 0;
        this.preResumeHookCalled = 0;
        return new TestMultipleAgentRunner(){

            protected void preInitHook() throws PogamutException {
                super.preInitHook();
                if (Test13_MultipleAgentRunner_PausingBehavior.this.preInitHookCalled != 0) {
                    throw new RuntimeException("preInitHook() called repeatedly!");
                }
                if (Test13_MultipleAgentRunner_PausingBehavior.this.preStartHookCalled != 0) {
                    throw new RuntimeException("preInitHook() called after some preStartHook were called!");
                }
                if (Test13_MultipleAgentRunner_PausingBehavior.this.postStartHookCalled != 0) {
                    throw new RuntimeException("preInitHook() called after some postStartHook were called!");
                }
                if (Test13_MultipleAgentRunner_PausingBehavior.this.postStartedHookCalled != 0) {
                    throw new RuntimeException("preInitHook() called after postStartedHookCalled was called!");
                }
                ++Test13_MultipleAgentRunner_PausingBehavior.this.preInitHookCalled;
            }

            protected void preStartHook(AbstractAgent agent) throws PogamutException {
                super.preStartHook((IAgent)agent);
                if (agent == null) {
                    throw new RuntimeException("preStartHook called with param agent==null!");
                }
                if (Test13_MultipleAgentRunner_PausingBehavior.this.preInitHookCalled == 0) {
                    throw new RuntimeException("preStartHook() called but no preInitHook was called!");
                }
                if (Test13_MultipleAgentRunner_PausingBehavior.this.preInitHookCalled != 1) {
                    throw new RuntimeException("preStartHook() called when more than one preInitHook was called!");
                }
                if (Test13_MultipleAgentRunner_PausingBehavior.this.postStartedHookCalled != 0) {
                    throw new RuntimeException("preStartHook() called after postStartedHookCalled was called!");
                }
                ++Test13_MultipleAgentRunner_PausingBehavior.this.preStartHookCalled;
            }

            protected void postStartHook(AbstractAgent agent) throws PogamutException {
                super.postStartHook((IAgent)agent);
                ++Test13_MultipleAgentRunner_PausingBehavior.this.postStartHookCalled;
                if (agent == null) {
                    throw new RuntimeException("postStartHook called with param agent==null!");
                }
                if (Test13_MultipleAgentRunner_PausingBehavior.this.preInitHookCalled == 0) {
                    throw new RuntimeException("postStartHook() called but no preInitHook was called!");
                }
                if (Test13_MultipleAgentRunner_PausingBehavior.this.preInitHookCalled != 1) {
                    throw new RuntimeException("postStartHook() called when more than one preInitHook was called!");
                }
                if (Test13_MultipleAgentRunner_PausingBehavior.this.preStartHookCalled != Test13_MultipleAgentRunner_PausingBehavior.this.postStartHookCalled) {
                    throw new RuntimeException("preStartHook num. of calls != postStartHook num of calls!");
                }
                if (Test13_MultipleAgentRunner_PausingBehavior.this.postStartedHookCalled != 0) {
                    throw new RuntimeException("postStartHook() called after postStartedHookCalled was called!");
                }
            }

            protected void postStartedHook(List<AbstractAgent> agents) {
                super.postStartedHook(agents);
                for (int i = 0; i < agents.size(); ++i) {
                    if (agents.get(i) == null) {
                        throw new RuntimeException("postStartedHook called with param agents[" + i + "] == null!");
                    }
                    if (Test13_MultipleAgentRunner_PausingBehavior.this.preInitHookCalled == 0) {
                        throw new RuntimeException("postStartedHook() called but no preInitHook was called!");
                    }
                    if (Test13_MultipleAgentRunner_PausingBehavior.this.preInitHookCalled != 1) {
                        throw new RuntimeException("postStartedHook() called when more than one preInitHook was called!");
                    }
                    if (Test13_MultipleAgentRunner_PausingBehavior.this.postStartedHookCalled != 0) {
                        throw new RuntimeException("postStartedHook() called repeatedly!");
                    }
                    if (Test13_MultipleAgentRunner_PausingBehavior.this.preStartHookCalled == Test13_MultipleAgentRunner_PausingBehavior.this.postStartHookCalled) continue;
                    throw new RuntimeException("preStartHook num. of calls != postStartHook num of calls!");
                }
                ++Test13_MultipleAgentRunner_PausingBehavior.this.postStartedHookCalled;
            }

            protected void preResumeHook(List<AbstractAgent> agents) {
                super.preResumeHook(agents);
                if (Test13_MultipleAgentRunner_PausingBehavior.this.preInitHookCalled == 0) {
                    throw new RuntimeException("preResumeHook() called but no preInitHook was called!");
                }
                if (Test13_MultipleAgentRunner_PausingBehavior.this.preInitHookCalled != 1) {
                    throw new RuntimeException("preResumeHook() called when more than one preInitHook was called!");
                }
                if (Test13_MultipleAgentRunner_PausingBehavior.this.preResumeHookCalled != 0) {
                    throw new RuntimeException("preResumeHook() called repeatedly!");
                }
                if (Test13_MultipleAgentRunner_PausingBehavior.this.preStartHookCalled != agents.size()) {
                    throw new RuntimeException(Test13_MultipleAgentRunner_PausingBehavior.this.preStartHookCalled + " agent started, but param agents.size() == " + agents.size() + "!");
                }
                for (int i = 0; i < agents.size(); ++i) {
                    if (((IAgentState)agents.get(i).getState().getFlag()).isState(new Class[]{IAgentStatePaused.class})) continue;
                    throw new RuntimeException("preResumeHook called, but param agents[" + i + "] is not in the state IAgentStatePaused");
                }
                ++Test13_MultipleAgentRunner_PausingBehavior.this.preResumeHookCalled;
            }
        }.setPausing(true);
    }

    protected void checkMultipleAgentRunnerCalls(int numAgents) {
        System.out.println("Checking agent runner calls...");
        if (this.preInitHookCalled == 0) {
            throw new RuntimeException("preInitHook() was not called at all!");
        }
        if (this.preInitHookCalled != 1) {
            throw new RuntimeException("preInitHook() was called more than once!");
        }
        if (this.preStartHookCalled != numAgents) {
            throw new RuntimeException(numAgents + " started, but preStartHook was called only " + this.preStartHookCalled + "x!");
        }
        if (this.postStartHookCalled != numAgents) {
            throw new RuntimeException(numAgents + " started, but postStartHook was called only " + this.postStartHookCalled + "x!");
        }
        if (this.preStartHookCalled != this.postStartHookCalled) {
            throw new RuntimeException("preStartHook num. of calls != postStartHook num of calls!");
        }
        if (this.postStartedHookCalled == 0) {
            throw new RuntimeException("postStartedHook() was not called at all!");
        }
        if (this.postStartedHookCalled != 1) {
            throw new RuntimeException("postStartedHook() was called more than once!");
        }
        if (this.preResumeHookCalled == 0) {
            throw new RuntimeException("preResumeHook() was not called at all!");
        }
        if (this.preResumeHookCalled != 1) {
            throw new RuntimeException("preResumeHook() was called more than once!");
        }
        System.out.println("OK");
    }

    public IAgentDescriptor[] initDescriptors(int numAgents) {
        int i;
        IAgentDescriptor[] result = new IAgentDescriptor[2];
        AgentDescriptor desc = new AgentDescriptor();
        desc.setAgentModule((GuiceAgentModule)new TestAgent1Module());
        for (i = 0; i < numAgents; ++i) {
            desc.addParams(new IAgentParameters[]{new TestAgentParams(i)});
        }
        result[0] = desc;
        desc = new AgentDescriptor();
        desc.setAgentModule((GuiceAgentModule)new TestAgent2Module());
        for (i = 0; i < numAgents; ++i) {
            desc.addParams(new IAgentParameters[]{new TestAgentParams(i)});
        }
        result[1] = desc;
        return result;
    }

    @Test
    public void test_start5Agents() {
        int i;
        IMultipleAgentRunner runner = this.initMultipleAgentRunner();
        int NUM_AGENTS = 5;
        System.out.println("Starting " + NUM_AGENTS + " agents...");
        List agents = runner.startAgents(this.initDescriptors(NUM_AGENTS));
        System.out.println("Checking agents classes...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            Assert.assertTrue((boolean)(agents.get(i) instanceof TestAgent1));
        }
        for (i = NUM_AGENTS; i < 2 * NUM_AGENTS; ++i) {
            Assert.assertTrue((boolean)(agents.get(i) instanceof TestAgent2));
        }
        System.out.println("OK");
        System.out.println("Checking agents running...");
        for (i = 0; i < 2 * NUM_AGENTS; ++i) {
            Assert.assertTrue((boolean)((IAgentState)((AbstractAgent)agents.get(i)).getState().getFlag()).isState(new Class[]{IAgentStateUp.class}));
        }
        System.out.println("OK");
        System.out.println("Check agents' parameters...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            Assert.assertTrue((((TestAgent1)((Object)agents.get(i))).getParam() == i ? 1 : 0) != 0);
        }
        for (i = NUM_AGENTS; i < 2 * NUM_AGENTS; ++i) {
            Assert.assertTrue((((TestAgent2)((Object)agents.get(i))).getParam() == i - NUM_AGENTS ? 1 : 0) != 0);
        }
        System.out.println("OK");
        System.out.println("Stopping " + 2 * NUM_AGENTS + " agents...");
        for (i = 0; i < 2 * NUM_AGENTS; ++i) {
            ((AbstractAgent)agents.get(i)).stop();
        }
        System.out.println("Checking agents stopped...");
        for (i = 0; i < 2 * NUM_AGENTS; ++i) {
            Assert.assertTrue((boolean)((IAgentState)((AbstractAgent)agents.get(i)).getState().getFlag()).isState(new Class[]{IAgentStateDown.class}));
        }
        System.out.println("OK");
        this.checkMultipleAgentRunnerCalls(2 * NUM_AGENTS);
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) {
        Test13_MultipleAgentRunner_PausingBehavior test = new Test13_MultipleAgentRunner_PausingBehavior();
        test.test_start5Agents();
        Test13_MultipleAgentRunner_PausingBehavior.tearDown();
    }
}

