/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.jmx;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.MockAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.jmx.proxy.AgentJMXProxy;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStatePaused;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStatePausing;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateResuming;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateStarting;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateStopped;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateStopping;
import cz.cuni.amis.pogamut.base.agent.state.level3.IAgentStateResumed;
import cz.cuni.amis.pogamut.base.agent.state.level3.IAgentStateStarted;
import cz.cuni.amis.pogamut.base.component.bus.ComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.flag.FlagListener;
import cz.cuni.amis.utils.flag.IFlag;
import cz.cuni.amis.utils.flag.WaitForFlagChange;
import cz.cuni.amis.utils.token.IToken;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.management.ObjectInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test01_AgentJMXProxy
extends BaseTest {
    AbstractAgent agent = null;
    ObjectInstance agentObjectInstance = null;
    AgentJMXProxy agentProxy = null;
    IToken token;

    @Before
    public void setUp() {
        AgentId agentId = new AgentId("Test01_AgentJMXProxy");
        this.token = agentId;
        AgentLogger logger = new AgentLogger((IAgentId)agentId);
        logger.addDefaultConsoleHandler();
        logger.setLevel(Level.ALL);
        ComponentBus bus = new ComponentBus((IAgentLogger)logger);
        this.agent = new MockAgent((IAgentId)agentId, (IComponentBus)bus, (IAgentLogger)logger);
        String agentAddress = this.agent.getJMX().enableJMX();
        this.agentProxy = new AgentJMXProxy(agentAddress);
    }

    @After
    public void tearDown() {
        Pogamut.getPlatform().close();
    }

    @Test
    public void testAgentNotifications() {
        final LinkedList<Class> expectingStateChanges = new LinkedList<Class>();
        expectingStateChanges.add(IAgentStateStarting.class);
        expectingStateChanges.add(IAgentStateStarted.class);
        expectingStateChanges.add(IAgentStatePausing.class);
        expectingStateChanges.add(IAgentStatePaused.class);
        expectingStateChanges.add(IAgentStateResuming.class);
        expectingStateChanges.add(IAgentStateResumed.class);
        expectingStateChanges.add(IAgentStatePausing.class);
        expectingStateChanges.add(IAgentStatePaused.class);
        expectingStateChanges.add(IAgentStateResuming.class);
        expectingStateChanges.add(IAgentStateResumed.class);
        expectingStateChanges.add(IAgentStateStopping.class);
        expectingStateChanges.add(IAgentStateStopped.class);
        FlagListener<IAgentState> stateListener = new FlagListener<IAgentState>(){

            public void flagChanged(IAgentState changedValue) {
                Class cls = (Class)expectingStateChanges.peek();
                if (cls.isAssignableFrom(changedValue.getClass())) {
                    System.out.println("CONSUMING " + cls);
                    expectingStateChanges.poll();
                }
            }
        };
        this.agentProxy.getState().addListener((FlagListener)stateListener);
        Assert.assertTrue((String)"name should be Test01_AgentJMXProxy", (boolean)this.agentProxy.getName().equals("Test01_AgentJMXProxy"));
        Assert.assertTrue((String)("token should be " + this.token.getToken()), (boolean)this.token.getToken().equals(this.agentProxy.getComponentId().getToken()));
        this.agent.start();
        this.agent.pause();
        this.agent.resume();
        this.agent.pause();
        this.agent.resume();
        this.agent.stop();
        new WaitForFlagChange((IFlag)this.agentProxy.getState(), (WaitForFlagChange.IAccept)new WaitForFlagChange.IAccept<IAgentState>(){

            public boolean accept(IAgentState flagValue) {
                return flagValue instanceof IAgentStateStopped;
            }
        }).await();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)("agent should have gone through all expected states, remaining state changes " + expectingStateChanges.size()), (expectingStateChanges.size() == 0 ? 1 : 0) != 0);
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) throws Exception {
        Test01_AgentJMXProxy test = new Test01_AgentJMXProxy();
        test.setUp();
        test.testAgentNotifications();
        test.tearDown();
    }
}

