/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.utils.runner;

import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgent1;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgent1Module;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgentParams;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgentRunner;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentFactory;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentModule;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.tests.BaseTest;
import java.util.List;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.Test;

public class Test03_AgentRunner_Starting5AgentsWithDifferentParams
extends BaseTest {
    static final int NUM_AGENTS = 5;

    @AfterClass
    public static void tearDown() {
        Pogamut.getPlatform().close();
    }

    @Test
    public void test_start5AgentsWithDifferentParams() {
        int i;
        TestAgentRunner runner = new TestAgentRunner((IAgentFactory)new GuiceAgentFactory((GuiceAgentModule)new TestAgent1Module()));
        System.out.println("Starting 5 agents with different parameters...");
        TestAgentParams[] params = new TestAgentParams[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            params[i2] = new TestAgentParams(i2);
        }
        List agents = runner.startAgents((IAgentParameters[])params);
        System.out.println("Checking agents classes...");
        for (i = 0; i < 5; ++i) {
            Assert.assertTrue((boolean)(agents.get(i) instanceof TestAgent1));
        }
        System.out.println("OK");
        System.out.println("Checking agents running...");
        for (i = 0; i < 5; ++i) {
            Assert.assertTrue((boolean)((IAgentState)((AbstractAgent)agents.get(i)).getState().getFlag()).isState(new Class[]{IAgentStateUp.class}));
        }
        System.out.println("OK");
        System.out.println("Check agents' parameters...");
        for (i = 0; i < 5; ++i) {
            Assert.assertTrue((((TestAgent1)((Object)agents.get(i))).getParam() == i ? 1 : 0) != 0);
        }
        System.out.println("OK");
        System.out.println("Stopping 5 agents...");
        for (i = 0; i < 5; ++i) {
            ((AbstractAgent)agents.get(i)).stop();
        }
        System.out.println("Checking agents stopped...");
        for (i = 0; i < 5; ++i) {
            Assert.assertTrue((boolean)((IAgentState)((AbstractAgent)agents.get(i)).getState().getFlag()).isState(new Class[]{IAgentStateDown.class}));
        }
        System.out.println("OK");
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) {
        Test03_AgentRunner_Starting5AgentsWithDifferentParams test = new Test03_AgentRunner_Starting5AgentsWithDifferentParams();
        test.test_start5AgentsWithDifferentParams();
        Test03_AgentRunner_Starting5AgentsWithDifferentParams.tearDown();
    }
}

