/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging;

import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.LogRecord;

public class LogCategoryFilter
implements java.util.logging.Filter {
    private LogCategory category = null;
    private Filter filter;
    private Set<LogCategory> categories = null;

    public LogCategoryFilter(LogCategory category) {
        this.category = category;
        this.filter = new LogSingleCategoryFilter();
    }

    public LogCategoryFilter(LogCategory[] categories) {
        this.categories = new HashSet<LogCategory>();
        for (LogCategory category : categories) {
            this.categories.add(category);
        }
        this.filter = new LogMultipleCategoriesFilter();
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        return this.filter.isLoggable(record);
    }

    public LogCategory[] getFilterCategories() {
        if (this.category != null) {
            return new LogCategory[]{this.category};
        }
        return this.categories.toArray(new LogCategory[this.categories.size()]);
    }

    private class LogMultipleCategoriesFilter
    implements Filter {
        private LogMultipleCategoriesFilter() {
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            return record.getParameters() != null && record.getParameters().length > 0 && LogCategoryFilter.this.categories.contains(record.getParameters()[0]);
        }
    }

    private class LogSingleCategoryFilter
    implements Filter {
        private LogSingleCategoryFilter() {
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            return record.getParameters() != null && record.getParameters().length > 0 && record.getParameters()[0] == LogCategoryFilter.this.category;
        }
    }

    private static interface Filter {
        public boolean isLoggable(LogRecord var1);
    }
}

