/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base3d.worldview.object;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import math.geom3d.Point3D;

public class Location
implements ILocated,
Serializable,
Cloneable {
    public static final Location NONE = new Location(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
    static final long serialVersionUID = -7001866845605943889L;
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;
    public static final Pattern locationPattern;
    public static final double DISTANCE_ZERO = 1.0E-9;

    public Location clone() {
        return new Location(this);
    }

    public Vector3d asVector3d() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public Point3d asPoint3d() {
        return new Point3d(this.x, this.y, this.z);
    }

    public Point3D asPoint3D() {
        return new Point3D(this.x, this.y, this.z);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public Location add(Location l) {
        return new Location(this.x + l.x, this.y + l.y, this.z + l.z);
    }

    public static Location add(Location l1, Location l2) {
        return new Location(l1.x + l2.x, l1.y + l2.y, l1.z + l2.z);
    }

    public Location sub(Location l) {
        return new Location(this.x - l.x, this.y - l.y, this.z - l.z);
    }

    public static Location sub(Location l1, Location l2) {
        return new Location(l1.x - l2.x, l1.y - l2.y, l1.z - l2.z);
    }

    public Location add(Velocity v) {
        return new Location(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public static Location add(Location l, Velocity v) {
        return new Location(l.x + v.x, l.y + v.y, l.z + v.z);
    }

    public Location sub(Velocity v) {
        return new Location(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public static Location sub(Location l, Velocity v) {
        return new Location(l.x - v.x, l.y - v.y, l.z - v.z);
    }

    public Location scale(double d) {
        return new Location(this.x * d, this.y * d, this.z * d);
    }

    public Location interpolate(Location l, double d) {
        double d1 = 1.0 - d;
        return new Location(d1 * this.x + d * l.x, d1 * this.y + d * l.y, d1 * this.z + d * l.z);
    }

    public static Location interpolate(Location l1, Location l2, double d) {
        double d1 = 1.0 - d;
        return new Location(d1 * l1.x + d * l2.x, d1 * l1.y + d * l2.y, d1 * l1.z + d * l2.z);
    }

    public boolean equals(Location v) {
        if (v == null) {
            return false;
        }
        return this.x == v.x && this.y == v.y && this.z == v.z;
    }

    public static boolean equal(Location l1, Location l2) {
        return l1.x == l2.x && l1.y == l2.y && l1.z == l2.z;
    }

    public boolean equals(Location l, double epsilon) {
        double d = this.x - l.x;
        double d2 = d >= 0.0 ? d : -d;
        if (d2 > epsilon) {
            return false;
        }
        d = this.y - l.y;
        double d3 = d >= 0.0 ? d : -d;
        if (d3 > epsilon) {
            return false;
        }
        d = this.z - l.z;
        double d4 = d >= 0.0 ? d : -d;
        return !(d4 > epsilon);
    }

    public static boolean equal(Location l1, Location l2, double epsilon) {
        double d = l1.x - l2.x;
        double d2 = d >= 0.0 ? d : -d;
        if (d2 > epsilon) {
            return false;
        }
        d = l1.y - l2.y;
        double d3 = d >= 0.0 ? d : -d;
        if (d3 > epsilon) {
            return false;
        }
        d = l1.z - l2.z;
        double d4 = d >= 0.0 ? d : -d;
        return !(d4 > epsilon);
    }

    public static Location getAverage(Collection<Location> locations) {
        if (locations.size() == 0) {
            return null;
        }
        Iterator<Location> iter = locations.iterator();
        Location result = new Location(iter.next());
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result.scale(1 / locations.size());
    }

    public double getDistance(Location l) {
        double dx = l.x - this.x;
        double dy = l.y - this.y;
        double dz = l.z - this.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double getDistance2D(Location l) {
        double dx = l.x - this.x;
        double dy = l.y - this.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double getDistance(Location l1, Location l2) {
        double dx = l2.x - l1.x;
        double dy = l2.y - l1.y;
        double dz = l2.z - l1.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double getDistanceZ(Location location) {
        return this.z - location.z;
    }

    public static double getDistance2D(Location l1, Location l2) {
        double dx = l2.x - l1.x;
        double dy = l2.y - l1.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double getDistanceSquare(Location l) {
        double dx = l.x - this.x;
        double dy = l.y - this.y;
        double dz = l.z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public static double getDistanceSquare(Location l1, Location l2) {
        double dx = l2.x - l1.x;
        double dy = l2.y - l1.y;
        double dz = l2.z - l1.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double getDistanceL1(Location l) {
        double dx = Math.abs(l.x - this.x);
        double dy = Math.abs(l.y - this.y);
        double dz = Math.abs(l.z - this.z);
        return dx + dy + dz;
    }

    public static double getDistanceL1(Location l1, Location l2) {
        double dx = Math.abs(l2.x - l1.x);
        double dy = Math.abs(l2.y - l1.y);
        double dz = Math.abs(l2.z - l1.z);
        return dx + dy + dz;
    }

    public double getDistanceLinf(Location l) {
        double dx = Math.abs(l.x - this.x);
        double dy = Math.abs(l.y - this.y);
        double dz = Math.abs(l.z - this.z);
        return Math.max(Math.max(dx, dy), dz);
    }

    public static double getDistanceLinf(Location l1, Location l2) {
        double dx = Math.abs(l2.x - l1.x);
        double dy = Math.abs(l2.y - l1.y);
        double dz = Math.abs(l2.z - l1.z);
        return Math.max(Math.max(dx, dy), dz);
    }

    public double getDistancePlane(Location l) {
        double dx = l.x - this.x;
        double dy = l.y - this.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double getDistancePlane(Location l1, Location l2) {
        double dx = l2.x - l1.x;
        double dy = l2.y - l1.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    public Location getLocation() {
        return this;
    }

    public Point3d getPoint3d() {
        return new Point3d(this.x, this.y, this.z);
    }

    public Location() {
    }

    public Location(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Location(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Location(Location source) {
        this.x = source.getX();
        this.y = source.getY();
        this.z = source.getZ();
    }

    public Location(String string) {
        Matcher m = locationPattern.matcher(string);
        if (m.find()) {
            String strX = m.group(1);
            String strY = m.group(3);
            String strZ = m.group(5);
            try {
                this.x = Double.parseDouble(strX);
            }
            catch (Exception e) {
                throw new RuntimeException("String '" + string + "', was not matched as Location, because X-coordinate '" + strX + "' is not a number.");
            }
            try {
                this.y = Double.parseDouble(strY);
            }
            catch (Exception e) {
                throw new RuntimeException("String '" + string + "', was not matched as Location, because Y-coordinate '" + strY + "' is not a number.");
            }
            try {
                this.z = Double.parseDouble(strZ);
            }
            catch (Exception e) {
                throw new RuntimeException("String '" + string + "', was not matched as Location, because Z-coordinate '" + strZ + "' is not a number.");
            }
        }
        throw new RuntimeException("String '" + string + "' was not matched as Location.");
    }

    public Location(double[] d) {
        if (d.length >= 1) {
            this.x = d[0];
        }
        if (d.length >= 2) {
            this.y = d[1];
        }
        if (d.length >= 3) {
            this.z = d[2];
        }
    }

    public Location(float[] f) {
        if (f.length >= 1) {
            this.x = f[0];
        }
        if (f.length >= 2) {
            this.y = f[1];
        }
        if (f.length >= 3) {
            this.z = f[2];
        }
    }

    public Location(Tuple3d p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public double dot(Location b) {
        return this.x * b.getX() + this.y * b.getY() + this.z * b.getZ();
    }

    public double dot2D(Location b) {
        return this.x * b.getX() + this.y * b.getY();
    }

    public Location cross(Location b) {
        return new Location(this.y * b.getZ() - this.z * b.getY(), this.z * b.getX() - this.x * b.getZ(), this.x * b.getY() - this.y * b.getX());
    }

    public Rotation getRotation(Rotation.Order order) {
        Location this_normalized = this.getNormalized();
        double yaw = 0.0;
        double pitch = 0.0;
        switch (order) {
            case YAW_PITCH_ROLL: 
            case ROLL_YAW_PITCH: 
            case YAW_ROLL_PITCH: {
                yaw = Math.atan2(this_normalized.getY(), Math.sqrt(1.0 - this_normalized.getY() * this_normalized.getY()));
                pitch = Math.atan2(this_normalized.getZ(), this_normalized.getX());
                break;
            }
            case PITCH_YAW_ROLL: 
            case PITCH_ROLL_YAW: 
            case ROLL_PITCH_YAW: {
                pitch = Math.atan2(Math.sqrt(1.0 - this_normalized.getZ() * this_normalized.getZ()), this_normalized.getZ());
                yaw = Math.atan2(this_normalized.getX(), this_normalized.getY());
            }
        }
        return new Rotation(pitch / Math.PI * 32768.0 - 1.0, yaw / Math.PI * 32768.0 - 1.0, 0.0);
    }

    public Rotation getQuatLikeRotationSeq(Rotation.Order order) {
        Location projected = new Location(1.0, 0.0, 0.0);
        double yaw = 0.0;
        double pitch = 0.0;
        switch (order) {
            case ROLL_YAW_PITCH: {
                yaw = Math.atan2(this.getY(), this.getX());
                projected = projected.mul(Rotation.constructXYRot(yaw));
                pitch = Math.atan2(this.getZ(), new Location(this.getX(), this.getY(), 0.0).dot(projected));
                return new Rotation(pitch / Math.PI * 32768.0 - 1.0, yaw / Math.PI * 32768.0 - 1.0, 0.0);
            }
        }
        return new Rotation();
    }

    public Location getNormalized() {
        return this.scale(1.0 / this.getLength());
    }

    public double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Location mul(Matrix3d matrix) {
        Location res = new Location();
        res.x = matrix.getM00() * this.x + matrix.getM10() * this.y + matrix.getM20() * this.z;
        res.y = matrix.getM01() * this.x + matrix.getM11() * this.y + matrix.getM21() * this.z;
        res.z = matrix.getM02() * this.x + matrix.getM12() * this.y + matrix.getM22() * this.z;
        return res;
    }

    public Location invert() {
        return new Location(-this.x, -this.y, -this.z);
    }

    public Location setTo(Location l) {
        this.x = l.x;
        this.y = l.y;
        this.z = l.z;
        return this;
    }

    public Location setTo(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location l = (Location)o;
        return this.getDistance(l) < 1.0E-9;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "[%.2f; %.2f; %.2f]", this.x, this.y, this.z);
    }

    static {
        PropertyEditorManager.registerEditor(Location.class, PropertyEditor.class);
        locationPattern = Pattern.compile("\\[([-+]?[0-9]+(\\.[0-9]+){0,1})\\; ([-+]?[0-9]+(\\.[0-9]+){0,1})\\; ([-+]?[0-9]+(\\.[0-9]+){0,1})\\]");
    }

    public static class PropertyEditor
    extends PropertyEditorSupport {
        @Override
        public String getAsText() {
            if (this.getValue() != null) {
                return this.getValue().toString();
            }
            return "null";
        }

        @Override
        public void setAsText(String s) {
            if ("null".equals(s.trim())) {
                this.setValue(null);
            } else {
                double[] d = PropertyEditor.parseNumberArray(s);
                if (d.length != 3) {
                    throw new IllegalArgumentException();
                }
                this.setValue(new Location(d));
            }
        }

        public static double[] parseNumberArray(String s) {
            if ((s = s.trim()).startsWith("[") && s.endsWith("]") || s.startsWith("(") && s.endsWith(")")) {
                s = s.substring(1, s.length() - 1);
            }
            StringTokenizer st = new StringTokenizer(s, ";");
            try {
                double[] d = new double[st.countTokens()];
                for (int i = 0; i < d.length; ++i) {
                    d[i] = Double.parseDouble(st.nextToken());
                }
                return d;
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        @Override
        public boolean supportsCustomEditor() {
            return false;
        }
    }
}

