/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging.jmx;

import cz.cuni.amis.introspection.jmx.DynamicProxy;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.exceptions.CantStartJMXException;
import cz.cuni.amis.pogamut.base.agent.exceptions.JMXAlreadyEnabledException;
import cz.cuni.amis.pogamut.base.utils.logging.AbstractAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.ILogCategories;
import cz.cuni.amis.pogamut.base.utils.logging.jmx.LogCategoriesJMXProxy;
import cz.cuni.amis.utils.Lazy;
import cz.cuni.amis.utils.exception.PogamutException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class AgentLoggerJMXProxy
extends AbstractAgentLogger {
    Lazy<ILogCategories> logCategories = new Lazy<ILogCategories>(){

        protected ILogCategories create() {
            return new LogCategoriesJMXProxy(AgentLoggerJMXProxy.this.mbsc, AgentLoggerJMXProxy.this.parentName);
        }
    };
    MBeanServerConnection mbsc = null;
    ObjectName parentName = null;
    DynamicProxy agentLoggerProxy;
    ILogCategories cats = null;

    public AgentLoggerJMXProxy(IAgentId agentName, MBeanServerConnection mbsc, ObjectName parentName) {
        super(agentName);
        this.mbsc = mbsc;
        this.parentName = parentName;
        ObjectName objectName = AgentLogger.getJMXAgentLoggerName(parentName);
        this.agentLoggerProxy = new DynamicProxy(objectName, mbsc);
    }

    @Override
    protected ILogCategories getLogCategories() {
        return (ILogCategories)this.logCategories.getVal();
    }

    @Override
    public void enableJMX(MBeanServer mBeanServer, ObjectName parent) throws JMXAlreadyEnabledException, CantStartJMXException {
        throw new UnsupportedOperationException("This logger is already a proxy to some remote logger. Making two proxies isn't the best practice, however it can be done, just implement this method based on DefaultAgentLogger's implementation of JMX.");
    }

    @Override
    public String getNetworkLoggerHost() {
        try {
            return (String)this.agentLoggerProxy.getAttribute("NetworkLoggerHost");
        }
        catch (Exception e) {
            throw new PogamutException("Could not invoke agentLoggerProxy.getAttribute(\"NetworkLoggerHost\").", (Throwable)e, (Object)this);
        }
    }

    @Override
    public Integer getNetworkLoggerPort() {
        try {
            return (Integer)this.agentLoggerProxy.getAttribute("NetworkLoggerPort");
        }
        catch (Exception e) {
            throw new PogamutException("Could not invoke agentLoggerProxy.getAttribute(\"NetworkLoggerPort\").", (Throwable)e, (Object)this);
        }
    }

    @Override
    public synchronized void addDefaultNetworkHandler() {
        try {
            this.agentLoggerProxy.invoke("addDefaultNetworkHandler", null, null);
        }
        catch (Exception e) {
            throw new PogamutException("Could not invoke agentLoggerProxy.invoke(\"addDefaultNetworkHandler\").", (Throwable)e, (Object)this);
        }
    }

    @Override
    public synchronized void removeDefaultNetworkHandler() {
        try {
            this.agentLoggerProxy.invoke("removeDefaultNetworkHandler", null, null);
        }
        catch (Exception e) {
            throw new PogamutException("Could not invoke agentLoggerProxy.invoke(\"removeDefaultNetworkHandler\").", (Throwable)e, (Object)this);
        }
    }

    @Override
    public boolean isDefaultNetworkHandler() {
        try {
            return (Boolean)this.agentLoggerProxy.getAttribute("DefaultNetworkHandler");
        }
        catch (Exception e) {
            throw new PogamutException("Could not invoke agentLoggerProxy.getAttribute(\"DefaultNetworkHandler\").", (Throwable)e, (Object)this);
        }
    }
}

