/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.stub.sharedcomponent;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.component.ISharedComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEventListener;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentState;
import cz.cuni.amis.pogamut.base.component.controller.ISharedComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.SharedComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.SharedComponentController;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.component.stub.sharedcomponent.CheckSharedEvent;
import cz.cuni.amis.pogamut.base.component.stub.sharedcomponent.EventToString;
import cz.cuni.amis.pogamut.base.component.stub.sharedcomponent.MethodToString;
import cz.cuni.amis.tests.ActivityLog;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AutoCheckSharedComponentController<COMPONENT extends ISharedComponent>
extends SharedComponentController<COMPONENT> {
    private ActivityLog activityLog;
    private List<CheckSharedEvent> expect = new LinkedList<CheckSharedEvent>();
    private Map<IAgentId, EventListener> listeners = new HashMap<IAgentId, EventListener>();
    private boolean shouldBeChecking = true;

    public AutoCheckSharedComponentController(COMPONENT component, Logger log) {
        super(component, (ISharedComponentControlHelper)new SharedComponentControlHelper(), log);
        this.activityLog = new ActivityLog(log);
        this.control = new CheckComponentControl();
    }

    public boolean isShouldBeChecking() {
        return this.shouldBeChecking;
    }

    public void setShouldBeChecking(boolean shouldBeChecking) {
        this.shouldBeChecking = shouldBeChecking;
    }

    public void addComponentBus(IAgentId agentId, ILifecycleBus bus, ComponentDependencies dependencies) {
        EventListener listener = new EventListener(agentId);
        this.listeners.put(agentId, listener);
        bus.addEventListener(IComponentEvent.class, (IComponentEventListener)listener);
        super.addComponentBus(agentId, bus, dependencies);
    }

    public void removeComponentBus(IAgentId agentId, ILifecycleBus bus) {
        super.removeComponentBus(agentId, bus);
        this.listeners.remove(agentId);
    }

    public void expectAnyOrder(String ... activity) {
        this.activityLog.expectAnyOrder(activity);
    }

    public void expectExactOrder(String ... activity) {
        this.activityLog.expectExactOrder(activity);
    }

    public void activity(String ... activity) {
        if (this.shouldBeChecking) {
            this.activityLog.activity(activity);
        }
    }

    public void checkNoMoreActivityExpected() {
        if (this.shouldBeChecking) {
            this.activityLog.checkNoMoreActivityExpected();
        }
    }

    private class CheckComponentControl
    extends SharedComponentControlHelper {
        private CheckComponentControl() {
        }

        public void kill() {
            AutoCheckSharedComponentController.this.activity(MethodToString.kill((ISharedComponent)AutoCheckSharedComponentController.this.component));
        }

        public void prePause() throws PogamutException {
            AutoCheckSharedComponentController.this.activity(MethodToString.prePause((ISharedComponent)AutoCheckSharedComponentController.this.component));
        }

        public void preResume() throws PogamutException {
            AutoCheckSharedComponentController.this.activity(MethodToString.preResume((ISharedComponent)AutoCheckSharedComponentController.this.component));
        }

        public void preStart() throws PogamutException {
            AutoCheckSharedComponentController.this.activity(MethodToString.preStart((ISharedComponent)AutoCheckSharedComponentController.this.component));
        }

        public void preStartPaused() throws PogamutException {
            AutoCheckSharedComponentController.this.activity(MethodToString.preStartPaused((ISharedComponent)AutoCheckSharedComponentController.this.component));
        }

        public void preStop() throws PogamutException {
            AutoCheckSharedComponentController.this.activity(MethodToString.preStop((ISharedComponent)AutoCheckSharedComponentController.this.component));
        }

        public void pause() throws PogamutException {
            if (AutoCheckSharedComponentController.this.getStateCount(new ComponentState[]{ComponentState.STARTING, ComponentState.RESUMING, ComponentState.RUNNING}) > 0) {
                throw new RuntimeException("Can't pause(), there are components starting/resuming/running.");
            }
            AutoCheckSharedComponentController.this.activity(MethodToString.pause((ISharedComponent)AutoCheckSharedComponentController.this.component));
        }

        public void reset() throws PogamutException {
            AutoCheckSharedComponentController.this.activity(MethodToString.reset((ISharedComponent)AutoCheckSharedComponentController.this.component));
        }

        public void resume() throws PogamutException {
            if (AutoCheckSharedComponentController.this.getStateCount(new ComponentState[]{ComponentState.STARTING, ComponentState.RESUMING, ComponentState.RUNNING}) == 0) {
                throw new RuntimeException("Can't resume(), there are NO components starting/resuming/running.");
            }
            AutoCheckSharedComponentController.this.activity(MethodToString.resume((ISharedComponent)AutoCheckSharedComponentController.this.component));
        }

        public void start() throws PogamutException {
            if (AutoCheckSharedComponentController.this.getStateCount(new ComponentState[]{ComponentState.STARTING, ComponentState.RESUMING, ComponentState.RUNNING}) == 0) {
                throw new RuntimeException("Can't start(), there are NO components starting/resuming/running.");
            }
            AutoCheckSharedComponentController.this.activity(MethodToString.start((ISharedComponent)AutoCheckSharedComponentController.this.component));
        }

        public void startPaused() throws PogamutException {
            if (AutoCheckSharedComponentController.this.getStateCount(new ComponentState[]{ComponentState.STARTING_PAUSED, ComponentState.PAUSING, ComponentState.PAUSED}) == 0) {
                throw new RuntimeException("Can't startPause(), there are NO components starting-paused/pausing/paused.");
            }
            AutoCheckSharedComponentController.this.activity(MethodToString.startPaused((ISharedComponent)AutoCheckSharedComponentController.this.component));
        }

        public void stop() throws PogamutException {
            if (AutoCheckSharedComponentController.this.getStateCount(new ComponentState[]{ComponentState.STARTING, ComponentState.RESUMING, ComponentState.RUNNING, ComponentState.PAUSING, ComponentState.PAUSED, ComponentState.STARTING_PAUSED}) != 0) {
                throw new RuntimeException("Can't stop(), there are components starting/resuming/running/pausing/paused/starting-paused.");
            }
            AutoCheckSharedComponentController.this.activity(MethodToString.stop((ISharedComponent)AutoCheckSharedComponentController.this.component));
        }

        public void localKill(IAgentId agentId) {
            AutoCheckSharedComponentController.this.activity(MethodToString.localKill((ISharedComponent)AutoCheckSharedComponentController.this.component, agentId));
        }

        public void localPause(IAgentId agentId) throws PogamutException {
            AutoCheckSharedComponentController.this.activity(MethodToString.localPause((ISharedComponent)AutoCheckSharedComponentController.this.component, agentId));
        }

        public void localPrePause(IAgentId agentId) throws PogamutException {
            AutoCheckSharedComponentController.this.activity(MethodToString.localPrePause((ISharedComponent)AutoCheckSharedComponentController.this.component, agentId));
        }

        public void localPreResume(IAgentId agentId) throws PogamutException {
            AutoCheckSharedComponentController.this.activity(MethodToString.localPreResume((ISharedComponent)AutoCheckSharedComponentController.this.component, agentId));
        }

        public void localPreStart(IAgentId agentId) throws PogamutException {
            AutoCheckSharedComponentController.this.activity(MethodToString.localPreStart((ISharedComponent)AutoCheckSharedComponentController.this.component, agentId));
        }

        public void localPreStartPaused(IAgentId agentId) throws PogamutException {
            AutoCheckSharedComponentController.this.activity(MethodToString.localPreStartPaused((ISharedComponent)AutoCheckSharedComponentController.this.component, agentId));
        }

        public void localPreStop(IAgentId agentId) throws PogamutException {
            AutoCheckSharedComponentController.this.activity(MethodToString.localPreStop((ISharedComponent)AutoCheckSharedComponentController.this.component, agentId));
        }

        public void localReset(IAgentId agentId) {
            AutoCheckSharedComponentController.this.activity(MethodToString.localReset((ISharedComponent)AutoCheckSharedComponentController.this.component, agentId));
        }

        public void localResume(IAgentId agentId) throws PogamutException {
            AutoCheckSharedComponentController.this.activity(MethodToString.localResume((ISharedComponent)AutoCheckSharedComponentController.this.component, agentId));
        }

        public void localStart(IAgentId agentId) throws PogamutException {
            AutoCheckSharedComponentController.this.activity(MethodToString.localStart((ISharedComponent)AutoCheckSharedComponentController.this.component, agentId));
        }

        public void localStartPaused(IAgentId agentId) throws PogamutException {
            AutoCheckSharedComponentController.this.activity(MethodToString.localStartPaused((ISharedComponent)AutoCheckSharedComponentController.this.component, agentId));
        }

        public void localStop(IAgentId agentId) throws PogamutException {
            AutoCheckSharedComponentController.this.activity(MethodToString.localStop((ISharedComponent)AutoCheckSharedComponentController.this.component, agentId));
        }
    }

    private class EventListener
    implements IComponentEventListener<IComponentEvent> {
        private IAgentId agentId;

        public EventListener(IAgentId agentId) {
            this.agentId = agentId;
        }

        public void notify(IComponentEvent event) {
            if (AutoCheckSharedComponentController.this.log.isLoggable(Level.INFO)) {
                AutoCheckSharedComponentController.this.log.info("Got event: " + event);
            }
            AutoCheckSharedComponentController.this.activity(EventToString.eventToString(this.agentId, event.getSource(), event.getClass()));
        }
    }
}

