/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.module;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.agent.module.LogicModule;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.ComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.stub.component.ComponentStub;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.junit.Test;

public class Test01_LogicModule
extends BaseTest {
    private Flag<Boolean> shutdown = new Flag((Object)false);
    private boolean init = false;
    private Flag<Boolean> logic = new Flag((Object)false);

    @Test
    public void test() {
        AgentId agentId = new AgentId("Test01_LogicModule");
        AgentLogger logger = new AgentLogger((IAgentId)agentId);
        logger.addDefaultConsoleHandler();
        logger.setLevel(Level.ALL);
        ComponentBus bus = new ComponentBus((IAgentLogger)logger);
        final ComponentStub starter = new ComponentStub((IAgentLogger)logger, (IComponentBus)bus);
        final LogCategory log = logger.getCategory("Logic");
        FlagListener<Boolean> logicListener = new FlagListener<Boolean>(){

            public void flagChanged(Boolean changedValue) {
                if (changedValue.booleanValue()) {
                    starter.getController().manualStop("Logic sensed.");
                }
            }
        };
        this.logic.addListener((FlagListener)logicListener);
        IAgentLogic agentLogic = new IAgentLogic(){

            public long getLogicInitializeTime() {
                return 0L;
            }

            public long getLogicShutdownTime() {
                return 0L;
            }

            public void logic() {
                if (log.isLoggable(Level.INFO)) {
                    log.info("Logic!!!");
                }
                if (((Boolean)Test01_LogicModule.this.logic.getFlag()).booleanValue()) {
                    Assert.fail((String)"logic should be called only once");
                }
                Test01_LogicModule.this.logic.setFlag((Object)true);
            }

            public void logicInitialize(LogicModule logicModule) {
                if (log.isLoggable(Level.INFO)) {
                    log.info("Logic initialize.");
                }
                if (Test01_LogicModule.this.init) {
                    Assert.fail((String)"logicInitialize could not be called twice");
                }
            }

            public void logicShutdown() {
                if (log.isLoggable(Level.INFO)) {
                    log.info("Logic shutdown.");
                }
                if (((Boolean)Test01_LogicModule.this.shutdown.getFlag()).booleanValue()) {
                    Assert.fail((String)"logicShutdown() could not be called twice");
                }
                Test01_LogicModule.this.shutdown.setFlag((Object)true);
            }
        };
        LogicModule logicModule = new LogicModule((IAgent)new AbstractAgent((IAgentId)agentId, (IComponentBus)bus, (IAgentLogger)logger){}, agentLogic, (Logger)log, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IComponent)starter));
        for (int i = 0; i < 20; ++i) {
            System.out.println("---((( Iteration " + i + " / 19 )))---");
            this.init = false;
            this.logic.setFlag((Object)false);
            this.shutdown.setFlag((Object)false);
            starter.getController().manualStart("Starting the logic.");
            Boolean result = (Boolean)this.shutdown.waitFor(10000L, (Object[])new Boolean[]{true});
            Assert.assertTrue((String)"logic should have terminated", (result != null && result != false ? 1 : 0) != 0);
        }
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) {
        Test01_LogicModule test = new Test01_LogicModule();
        test.test();
    }
}

