/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging.network;

import cz.cuni.amis.pogamut.base.utils.logging.NetworkLogClient;
import cz.cuni.amis.pogamut.base.utils.logging.NetworkLogEnvelope;
import cz.cuni.amis.utils.Throughput;
import java.util.logging.Level;

public class CheckNetworkLogClient
extends NetworkLogClient {
    private int myLogFinestLogs = 0;
    private int myLogFinerLogs = 0;
    private int myLogFineLogs = 0;
    private int myLogInfoLogs = 0;
    private int myLogWarningLogs = 0;
    private int myLogSevereLogs = 0;
    private Throughput throughput = new Throughput("bytes");
    private int lastLogNumber = -1;
    private boolean firstLog = true;
    private NetworkLogClient.ILogReadListener logReadListener = new NetworkLogClient.ILogReadListener(){

        public void notify(NetworkLogClient.LogRead event) {
            if (CheckNetworkLogClient.this.firstLog) {
                CheckNetworkLogClient.this.firstLog = false;
                CheckNetworkLogClient.this.log.info("First log received: " + event.getRecord());
            }
            NetworkLogEnvelope log = event.getRecord();
            CheckNetworkLogClient.this.throughput.add((long)log.toString().length());
            if (log.getCategory().equals("my-log") && log.getMessage().startsWith("!!!")) {
                int index = log.getMessage().lastIndexOf("-") + 2;
                int num = 0;
                try {
                    num = Integer.parseInt(log.getMessage().substring(index));
                }
                catch (NumberFormatException e) {
                    System.out.println("ouch");
                    throw e;
                }
                if (num == 0) {
                    CheckNetworkLogClient.this.lastLogNumber = 0;
                } else {
                    if (CheckNetworkLogClient.this.lastLogNumber != num && CheckNetworkLogClient.this.lastLogNumber + 1 != num) {
                        System.out.println("[ERROR] Last log number: " + CheckNetworkLogClient.this.lastLogNumber + ", current log number = " + num);
                        throw new RuntimeException("[ERROR] Last log number: " + CheckNetworkLogClient.this.lastLogNumber + ", current log number = " + num);
                    }
                    CheckNetworkLogClient.this.lastLogNumber = num;
                }
                if (log.getLevel() == Level.FINEST) {
                    ++CheckNetworkLogClient.this.myLogFinestLogs;
                } else if (log.getLevel() == Level.FINER) {
                    ++CheckNetworkLogClient.this.myLogFinerLogs;
                } else if (log.getLevel() == Level.FINE) {
                    ++CheckNetworkLogClient.this.myLogFineLogs;
                } else if (log.getLevel() == Level.INFO) {
                    ++CheckNetworkLogClient.this.myLogInfoLogs;
                } else if (log.getLevel() == Level.WARNING) {
                    ++CheckNetworkLogClient.this.myLogWarningLogs;
                } else if (log.getLevel() == Level.SEVERE) {
                    ++CheckNetworkLogClient.this.myLogSevereLogs;
                }
            }
        }
    };
    private String name;

    public CheckNetworkLogClient(String name, String address, int port, String agentId) {
        super(address, port, agentId);
        this.addListener(this.logReadListener);
        this.getLogger().setLevel(Level.ALL);
        this.name = name;
        this.throughput.setReporting(true);
        this.throughput.setName(name + "-" + "Throughput");
    }

    public String getName() {
        return this.name;
    }

    public Throughput getThroughput() {
        return this.throughput;
    }

    public void checkLogNumber(int number) {
        if (this.myLogFinestLogs != number) {
            System.out.println("[ERROR] " + this.name + " finest logs number  = " + this.myLogFinestLogs + " != " + number);
            throw new RuntimeException("[ERROR] " + this.name + " finest logs number  = " + this.myLogFinestLogs + " != " + number);
        }
        if (this.myLogFinerLogs != number) {
            System.out.println("[ERROR] " + this.name + " finer logs number   = " + this.myLogFinerLogs + " != " + number);
            throw new RuntimeException("[ERROR] " + this.name + " finer logs number   = " + this.myLogFinerLogs + " != " + number);
        }
        if (this.myLogFineLogs != number) {
            System.out.println("[ERROR] " + this.name + " fine logs number    = " + this.myLogFineLogs + " != " + number);
            throw new RuntimeException("[ERROR] " + this.name + " fine logs number    = " + this.myLogFineLogs + " != " + number);
        }
        if (this.myLogInfoLogs != number) {
            System.out.println("[ERROR] " + this.name + " info logs number    = " + this.myLogInfoLogs + " != " + number);
            throw new RuntimeException("[ERROR] " + this.name + " info logs number    = " + this.myLogInfoLogs + " != " + number);
        }
        if (this.myLogWarningLogs != number) {
            System.out.println("[ERROR] " + this.name + " warning logs number = " + this.myLogWarningLogs + " != " + number);
            throw new RuntimeException("[ERROR] " + this.name + " warning logs number = " + this.myLogWarningLogs + " != " + number);
        }
        if (this.myLogSevereLogs != number) {
            System.out.println("[ERROR] " + this.name + " severe logs number  = " + this.myLogSevereLogs + " != " + number);
            throw new RuntimeException("[ERROR] " + this.name + " severe logs number  = " + this.myLogSevereLogs + " != " + number);
        }
    }
}

