/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.controller;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.ComponentController;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.controller.ComponentState;
import cz.cuni.amis.pogamut.base.component.controller.IComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.LifecycleBus;
import cz.cuni.amis.pogamut.base.component.stub.component.ManualCheckComponent;
import cz.cuni.amis.pogamut.base.component.stub.sharedcomponent.AutoCheckSharedComponent;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.StopWatch;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Test;

public class Test24_SharedComponentController_Concurrency
extends BaseTest {
    private static final Level loggingLevel = Level.WARNING;
    private static RuntimeException exception = null;
    private static CountDownLatch latch;

    private static void checkState(AutoCheckSharedComponent sharedComp, ComponentState state) {
        if (sharedComp.getController().notInState(new ComponentState[]{state})) {
            String msg = "[ERROR] " + sharedComp.getComponentId().getToken() + " is not in state " + state + " but in state " + sharedComp.getController().getState().getFlag() + ", INVALID!";
            System.out.println(msg);
            exception = new RuntimeException(msg);
            while (latch != null && latch.getCount() > 0L) {
                latch.countDown();
            }
            throw exception;
        }
    }

    private static void performTest(int agents, int operations, AutoCheckSharedComponent sharedComp) {
        int i;
        OneAgent.COUNTER = 1;
        exception = null;
        latch = new CountDownLatch(agents);
        OneAgent[] agent = new OneAgent[agents];
        for (i = 0; i < agents; ++i) {
            System.out.println("CREATING AGENT " + (i + 1) + " / " + agents);
            agent[i] = new OneAgent(sharedComp, i % 2 == 0 ? ComponentDependencyType.STARTS_WITH : ComponentDependencyType.STARTS_AFTER, operations);
        }
        for (i = 0; i < agents; ++i) {
            System.out.println("STARTING AGENT " + (i + 1) + " / " + agents);
            new Thread((Runnable)agent[i], "CheckThread-" + i).start();
        }
        try {
            latch.await(agents * operations * 1000, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            if (exception != null) {
                throw exception;
            }
            throw new RuntimeException("Interrupted on the latch!", e);
        }
        if (exception != null) {
            throw exception;
        }
        Test24_SharedComponentController_Concurrency.checkState(sharedComp, ComponentState.STOPPED);
    }

    @Test
    public void test01() {
        int agents = 1;
        int operations = 10;
        System.out.println("--- TEST: agents = " + agents + ", operations = " + operations + " ---");
        System.out.println("In case of exception, set static field loggingLevel to Level.ALL and rerun!");
        AgentId id = new AgentId("SharedComponents");
        AgentLogger logger = new AgentLogger((IAgentId)id);
        AutoCheckSharedComponent sharedComp = new AutoCheckSharedComponent((IAgentLogger)logger);
        sharedComp.setShouldBeChecking(false);
        StopWatch watch = new StopWatch();
        Test24_SharedComponentController_Concurrency.performTest(agents, operations, sharedComp);
        System.out.println(agents * operations + " operations finished in " + watch.stopStr());
        System.out.println("---/// TEST OK (agents = " + agents + ", operations = " + operations + ") ///---");
    }

    @Test
    public void test02() {
        int agents = 2;
        int operations = 10;
        System.out.println("--- TEST: agents = " + agents + ", operations = " + operations + " ---");
        System.out.println("In case of exception, set static field loggingLevel to Level.ALL and rerun!");
        AgentId id = new AgentId("Shared");
        AgentLogger logger = new AgentLogger((IAgentId)id);
        logger.addDefaultConsoleHandler();
        logger.setLevel(loggingLevel);
        AutoCheckSharedComponent sharedComp = new AutoCheckSharedComponent((IAgentLogger)logger);
        sharedComp.setShouldBeChecking(false);
        StopWatch watch = new StopWatch();
        Test24_SharedComponentController_Concurrency.performTest(agents, operations, sharedComp);
        System.out.println(agents * operations + " operations finished in " + watch.stopStr());
        System.out.println("---/// TEST OK (agents = " + agents + ", operations = " + operations + ") ///---");
    }

    @Test
    public void test03() {
        int agents = 3;
        int operations = 10;
        System.out.println("--- TEST: agents = " + agents + ", operations = " + operations + " ---");
        System.out.println("In case of exception, set static field loggingLevel to Level.ALL and rerun!");
        AgentId id = new AgentId("Shared");
        AgentLogger logger = new AgentLogger((IAgentId)id);
        logger.addDefaultConsoleHandler();
        logger.setLevel(loggingLevel);
        AutoCheckSharedComponent sharedComp = new AutoCheckSharedComponent((IAgentLogger)logger);
        sharedComp.setShouldBeChecking(false);
        StopWatch watch = new StopWatch();
        Test24_SharedComponentController_Concurrency.performTest(agents, operations, sharedComp);
        System.out.println(agents * operations + " operations finished in " + watch.stopStr());
        System.out.println("---/// TEST OK (agents = " + agents + ", operations = " + operations + ") ///---");
    }

    @Test
    public void test04() {
        int agents = 10;
        int operations = 100;
        System.out.println("--- TEST: agents = " + agents + ", operations = " + operations + " ---");
        System.out.println("In case of exception, set static field loggingLevel to Level.ALL and rerun!");
        AgentId id = new AgentId("Shared");
        AgentLogger logger = new AgentLogger((IAgentId)id);
        logger.addDefaultConsoleHandler();
        logger.setLevel(loggingLevel);
        AutoCheckSharedComponent sharedComp = new AutoCheckSharedComponent((IAgentLogger)logger);
        sharedComp.setShouldBeChecking(false);
        StopWatch watch = new StopWatch();
        Test24_SharedComponentController_Concurrency.performTest(agents, operations, sharedComp);
        System.out.println(agents * operations + " operations finished in " + watch.stopStr());
        System.out.println("---/// TEST OK (agents = " + agents + ", operations = " + operations + ") ///---");
    }

    @Test
    public void test05() {
        int agents = 10;
        int operations = 1000;
        System.out.println("--- TEST: agents = " + agents + ", operations = " + operations + " ---");
        System.out.println("In case of exception, set static field loggingLevel to Level.ALL and rerun!");
        AgentId id = new AgentId("Shared");
        AgentLogger logger = new AgentLogger((IAgentId)id);
        logger.addDefaultConsoleHandler();
        logger.setLevel(loggingLevel);
        AutoCheckSharedComponent sharedComp = new AutoCheckSharedComponent((IAgentLogger)logger);
        sharedComp.setShouldBeChecking(false);
        StopWatch watch = new StopWatch();
        Test24_SharedComponentController_Concurrency.performTest(agents, operations, sharedComp);
        System.out.println(agents * operations + " operations finished in " + watch.stopStr());
        System.out.println("---/// TEST OK (agents = " + agents + ", operations = " + operations + ") ///---");
    }

    @Test
    public void test06() {
        int agents = 100;
        int operations = 100;
        System.out.println("--- TEST: agents = " + agents + ", operations = " + operations + " ---");
        System.out.println("In case of exception, set static field loggingLevel to Level.ALL and rerun!");
        AgentId id = new AgentId("Shared");
        AgentLogger logger = new AgentLogger((IAgentId)id);
        logger.addDefaultConsoleHandler();
        logger.setLevel(loggingLevel);
        AutoCheckSharedComponent sharedComp = new AutoCheckSharedComponent((IAgentLogger)logger);
        sharedComp.setShouldBeChecking(false);
        StopWatch watch = new StopWatch();
        Test24_SharedComponentController_Concurrency.performTest(agents, operations, sharedComp);
        System.out.println(agents * operations + " operations finished in " + watch.stopStr());
        System.out.println("---/// TEST OK (agents = " + agents + ", operations = " + operations + ") ///---");
    }

    @Test
    public void test07() {
        int agents = 100;
        int operations = 1000;
        System.out.println("--- TEST: agents = " + agents + ", operations = " + operations + " ---");
        System.out.println("In case of exception, set static field loggingLevel to Level.ALL and rerun!");
        AgentId id = new AgentId("Shared");
        AgentLogger logger = new AgentLogger((IAgentId)id);
        logger.addDefaultConsoleHandler();
        logger.setLevel(loggingLevel);
        AutoCheckSharedComponent sharedComp = new AutoCheckSharedComponent((IAgentLogger)logger);
        sharedComp.setShouldBeChecking(false);
        StopWatch watch = new StopWatch();
        Test24_SharedComponentController_Concurrency.performTest(agents, operations, sharedComp);
        System.out.println(agents * operations + " operations finished in " + watch.stopStr());
        System.out.println("---/// TEST OK (agents = " + agents + ", operations = " + operations + ") ///---");
    }

    private static class OneAgent
    implements Runnable {
        private static int COUNTER = 1;
        private AgentId agentId;
        private AgentLogger logger;
        private LifecycleBus bus;
        private ManualCheckComponent manualComp0;
        private ManualCheckComponent manualComp1;
        private ComponentController manualCompCtrl1;
        private int operations;
        private Random random;
        private AutoCheckSharedComponent sharedComp;

        public OneAgent(AutoCheckSharedComponent sharedComp, ComponentDependencyType type, int operations) {
            this.sharedComp = sharedComp;
            this.agentId = new AgentId("Agent" + COUNTER++);
            this.logger = new AgentLogger((IAgentId)this.agentId);
            this.logger.addDefaultConsoleHandler();
            this.logger.setLevel(loggingLevel);
            this.bus = new LifecycleBus((IAgentLogger)this.logger);
            this.manualComp0 = new ManualCheckComponent((IAgentLogger)this.logger, (IComponentBus)this.bus);
            this.manualComp1 = new ManualCheckComponent((IAgentLogger)this.logger, (IComponentBus)this.bus);
            this.manualCompCtrl1 = new ComponentController((IComponent)this.manualComp1, (IComponentControlHelper)new ComponentControlHelper(), (ILifecycleBus)this.bus, (Logger)this.logger.getCategory(this.manualComp1.getComponentId().getToken()), new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IComponent)this.manualComp0));
            sharedComp.addComponentBus((IAgentId)this.agentId, (ILifecycleBus)this.bus, new ComponentDependencies(type).add((IComponent)this.manualComp1));
            this.operations = operations;
            this.random = new Random(System.currentTimeMillis());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ComponentState lastState = ComponentState.STOPPED;
                int operation = 0;
                block18: for (int i = 0; i < this.operations; ++i) {
                    switch (lastState) {
                        case STOPPED: {
                            System.out.println((String)this.agentId.getName().getFlag() + " - STARTING (operation " + (i + 1) + " / " + this.operations + ")");
                            this.manualComp0.manualStart();
                            lastState = ComponentState.RUNNING;
                            Test24_SharedComponentController_Concurrency.checkState(this.sharedComp, ComponentState.RUNNING);
                            System.out.println((String)this.agentId.getName().getFlag() + " - RUNNING");
                            continue block18;
                        }
                        case RUNNING: {
                            operation = this.random.nextInt(2);
                            switch (operation) {
                                case 0: {
                                    System.out.println((String)this.agentId.getName().getFlag() + " - STOPPING (operation " + (i + 1) + " / " + this.operations + ")");
                                    this.manualComp0.manualStop();
                                    lastState = ComponentState.STOPPED;
                                    System.out.println((String)this.agentId.getName().getFlag() + " - STOPPED");
                                    break;
                                }
                                case 1: {
                                    System.out.println((String)this.agentId.getName().getFlag() + " - PAUSING (operation " + (i + 1) + " / " + this.operations + ")");
                                    this.manualComp0.manualPause();
                                    lastState = ComponentState.PAUSED;
                                    System.out.println((String)this.agentId.getName().getFlag() + " - PAUSED");
                                }
                            }
                            continue block18;
                        }
                        case PAUSED: {
                            operation = this.random.nextInt(2);
                            switch (operation) {
                                case 0: {
                                    System.out.println((String)this.agentId.getName().getFlag() + " - STOPPING (operation " + (i + 1) + " / " + this.operations + ")");
                                    this.manualComp0.manualStop();
                                    lastState = ComponentState.STOPPED;
                                    System.out.println((String)this.agentId.getName().getFlag() + " - STOPPED");
                                    break;
                                }
                                case 1: {
                                    System.out.println((String)this.agentId.getName().getFlag() + " - RESUMING (operation " + (i + 1) + " / " + this.operations + ")");
                                    this.manualComp0.manualResume();
                                    lastState = ComponentState.RUNNING;
                                    Test24_SharedComponentController_Concurrency.checkState(this.sharedComp, ComponentState.RUNNING);
                                    System.out.println((String)this.agentId.getName().getFlag() + " - RUNNING");
                                }
                            }
                            continue block18;
                        }
                        default: {
                            throw exception = new RuntimeException("INVALID SWITCH CASE = " + lastState);
                        }
                    }
                }
                if (lastState != ComponentState.STOPPED) {
                    this.manualComp0.manualStop();
                }
            }
            catch (Exception e) {
                exception = new RuntimeException("EXCEPTION!", e);
                while (latch != null && latch.getCount() > 0L) {
                    latch.countDown();
                }
            }
            finally {
                latch.countDown();
            }
        }
    }
}

