/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.utils;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.state.WaitForAgentStateChange;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateGoingUp;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.flag.Flag;
import java.util.logging.Level;

public class AgentKeepAlive {
    private Object keepAliveMutex = new Object();
    private LogCategory log;
    private KeepAlive keepAlive = null;
    private boolean firstStart = false;
    private IAgent agent;
    private boolean running = false;
    private long reconnectMillis;

    public AgentKeepAlive(IAgent agent, long reconnectWaitMillis) {
        this.agent = agent;
        NullCheck.check((Object)this.agent, (String)"agent");
        this.log = agent.getLogger().getCategory(this.getClass().getSimpleName());
        NullCheck.check((Object)this.log, (String)"log initialization");
        this.reconnectMillis = reconnectWaitMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.keepAliveMutex;
        synchronized (object) {
            if (this.running) {
                return;
            }
            IAgentState state = (IAgentState)this.agent.getState().getFlag();
            this.firstStart = true;
            this.keepAlive = new KeepAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.keepAliveMutex;
        synchronized (object) {
            if (this.keepAlive != null) {
                this.keepAlive.stop();
                this.keepAlive = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNextRestart() {
        Object object = this.keepAliveMutex;
        synchronized (object) {
            if (!this.running) {
                return null;
            }
            return this.keepAlive.getNextRestart();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    private class KeepAlive
    implements Runnable {
        private Thread reconnectThread = null;
        private boolean shouldRun = true;
        private boolean shouldReconnect = true;
        private long sleepMillis = -1L;

        public KeepAlive() {
            this.reconnectThread = new Thread((Runnable)this, AgentKeepAlive.this.agent.getName() + " reconnector");
            this.reconnectThread.start();
        }

        public void stop() {
            if (AgentKeepAlive.this.log.isLoggable(Level.WARNING)) {
                AgentKeepAlive.this.log.warning("Stopping KeepAlive.");
            }
            this.shouldReconnect = false;
            this.shouldRun = false;
            this.reconnectThread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Long getNextRestart() {
            Object object = AgentKeepAlive.this.keepAliveMutex;
            synchronized (object) {
                if (this.sleepMillis < 0L) {
                    return null;
                }
                return System.currentTimeMillis() - this.sleepMillis - AgentKeepAlive.this.reconnectMillis;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            Object result = null;
            while (this.shouldRun && !Thread.currentThread().isInterrupted()) {
                if (this.shouldReconnect) {
                    try {
                        if (!AgentKeepAlive.this.firstStart) {
                            object = AgentKeepAlive.this.keepAliveMutex;
                            synchronized (object) {
                                this.sleepMillis = System.currentTimeMillis();
                            }
                            if (AgentKeepAlive.this.log.isLoggable(Level.FINER)) {
                                AgentKeepAlive.this.log.finer("Next reconnect attempt in " + AgentKeepAlive.this.reconnectMillis + " ms.");
                            }
                            Thread.sleep(AgentKeepAlive.this.reconnectMillis);
                        }
                        if (!this.shouldReconnect) break;
                        try {
                            IAgentState state = (IAgentState)AgentKeepAlive.this.agent.getState().getFlag();
                            if (state instanceof IAgentStateUp || state instanceof IAgentStateGoingUp) {
                                this.shouldReconnect = false;
                                continue;
                            }
                            if (AgentKeepAlive.this.firstStart) {
                                if (AgentKeepAlive.this.log.isLoggable(Level.INFO)) {
                                    AgentKeepAlive.this.log.info("Starting agent.");
                                }
                                AgentKeepAlive.this.firstStart = false;
                            } else if (AgentKeepAlive.this.log.isLoggable(Level.INFO)) {
                                AgentKeepAlive.this.log.info("Restarting agent.");
                            }
                            AgentKeepAlive.this.agent.start();
                            if (AgentKeepAlive.this.log.isLoggable(Level.INFO)) {
                                AgentKeepAlive.this.log.info("Agent started.");
                            }
                        }
                        catch (Exception e1) {
                            if (!this.shouldReconnect) break;
                            if (AgentKeepAlive.this.log.isLoggable(Level.INFO)) {
                                AgentKeepAlive.this.log.info("Agent did not start, killing agent (cleaning up).");
                            }
                            try {
                                AgentKeepAlive.this.agent.kill();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (Exception e) {
                        if (!this.shouldReconnect || !AgentKeepAlive.this.log.isLoggable(Level.SEVERE)) break;
                        AgentKeepAlive.this.log.severe(ExceptionToString.process((String)("Unhandled exception, stopping " + AgentKeepAlive.this.getClass().getSimpleName() + "."), (Throwable)e));
                        break;
                    }
                }
                try {
                    new WaitForAgentStateChange((Flag<IAgentState>)AgentKeepAlive.this.agent.getState(), (Class<? extends IAgentState>)IAgentStateDown.class).await();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.shouldReconnect = AgentKeepAlive.this.agent.getState().getFlag() instanceof IAgentStateDown;
            }
            this.reconnectThread = null;
            object = AgentKeepAlive.this.keepAliveMutex;
            synchronized (object) {
                if (AgentKeepAlive.this.keepAlive == this) {
                    AgentKeepAlive.this.running = false;
                    AgentKeepAlive.this.keepAlive = null;
                }
            }
            if (AgentKeepAlive.this.log.isLoggable(Level.WARNING)) {
                AgentKeepAlive.this.log.warning("Stopped.");
            }
        }
    }
}

