/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.jmx;

import cz.cuni.amis.utils.HashCode;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.SafeEquals;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

public class PogamutMBeanServer
implements MBeanServer {
    private MBeanServer mbs;
    private Set<RegisteredMBean> unregisteredMBeans = new HashSet<RegisteredMBean>();
    private Set<RegisteredMBean> mBeans = new HashSet<RegisteredMBean>();
    private Set<RegisteredListener> unregisteredListeners = new HashSet<RegisteredListener>();
    private Set<RegisteredListener> listeners = new HashSet<RegisteredListener>();
    private Set<Listener1> listeners1 = new HashSet<Listener1>();
    private Set<Listener2> listeners2 = new HashSet<Listener2>();

    public PogamutMBeanServer() {
        this(MBeanServerFactory.createMBeanServer());
    }

    public PogamutMBeanServer(MBeanServer mBeanServer) {
        this.mbs = mBeanServer;
        NullCheck.check((Object)this.mbs, (String)"mBeanServer");
    }

    public synchronized void clearSaved() {
        this.unregisteredMBeans.clear();
        this.unregisteredListeners.clear();
    }

    public synchronized void unregisterAll() {
        Iterator<RegisteredListener> iter1 = this.listeners.iterator();
        while (iter1.hasNext()) {
            RegisteredListener listener = iter1.next();
            listener.unregister();
            iter1.remove();
            this.unregisteredListeners.add(listener);
        }
        Iterator<RegisteredMBean> iter2 = this.mBeans.iterator();
        while (iter2.hasNext()) {
            RegisteredMBean mBean = iter2.next();
            mBean.unregister();
            this.unregisteredMBeans.add(mBean);
            iter2.remove();
        }
    }

    public synchronized void registerAll() throws InstanceNotFoundException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        Iterator<RegisteredMBean> iter1 = this.unregisteredMBeans.iterator();
        while (iter1.hasNext()) {
            RegisteredMBean mBean = iter1.next();
            mBean.register();
            iter1.remove();
            this.mBeans.add(mBean);
        }
        Iterator<RegisteredListener> iter2 = this.unregisteredListeners.iterator();
        while (iter2.hasNext()) {
            RegisteredListener listener = iter2.next();
            listener.register();
            iter2.remove();
            if (listener instanceof Listener1) {
                this.listeners1.add((Listener1)listener);
                continue;
            }
            this.listeners2.add((Listener2)listener);
        }
    }

    @Override
    public synchronized void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.mbs.addNotificationListener(name, listener, filter, handback);
        Listener2 l = new Listener2(name, listener, filter, handback);
        this.listeners.add(l);
        this.listeners2.add(l);
    }

    private synchronized void innerAddNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.mbs.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public synchronized void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.mbs.addNotificationListener(name, listener, filter, handback);
        Listener1 l = new Listener1(name, listener, filter, handback);
        this.listeners.add(l);
        this.listeners1.add(l);
    }

    private synchronized void innerAddNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.mbs.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public synchronized ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        throw new UnsupportedOperationException("Not supported by PogamutMBeanServer yet...");
    }

    @Override
    public synchronized ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        throw new UnsupportedOperationException("Not supported by PogamutMBeanServer yet...");
    }

    @Override
    public synchronized ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        throw new UnsupportedOperationException("Not supported by PogamutMBeanServer yet...");
    }

    @Override
    public synchronized ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        throw new UnsupportedOperationException("Not supported by PogamutMBeanServer yet...");
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        return this.mbs.deserialize(name, data);
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        return this.mbs.deserialize(className, data);
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        return this.mbs.deserialize(className, loaderName, data);
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.mbs.getAttribute(name, attribute);
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        return this.mbs.getAttributes(name, attributes);
    }

    @Override
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        return this.mbs.getClassLoader(loaderName);
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        return this.mbs.getClassLoaderFor(mbeanName);
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        return this.mbs.getClassLoaderRepository();
    }

    @Override
    public String getDefaultDomain() {
        return this.mbs.getDefaultDomain();
    }

    @Override
    public String[] getDomains() {
        return this.mbs.getDomains();
    }

    @Override
    public Integer getMBeanCount() {
        return this.mbs.getMBeanCount();
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.mbs.getMBeanInfo(name);
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.mbs.getObjectInstance(name);
    }

    @Override
    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.mbs.instantiate(className);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.mbs.instantiate(className, loaderName);
    }

    @Override
    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        return this.mbs.instantiate(className, params, signature);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.mbs.instantiate(className, loaderName, params, signature);
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.mbs.invoke(name, operationName, params, signature);
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return this.mbs.isInstanceOf(name, className);
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        return this.mbs.isRegistered(name);
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        return this.mbs.queryMBeans(name, query);
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        return this.mbs.queryNames(name, query);
    }

    @Override
    public synchronized ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectInstance obj = this.mbs.registerMBean(object, name);
        this.mBeans.add(new MBean1(name, object));
        this.unregisteredMBeans.remove(new MBean1(name, object));
        return obj;
    }

    private synchronized ObjectInstance innerRegisterMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.mbs.registerMBean(object, name);
    }

    @Override
    public synchronized void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbs.removeNotificationListener(name, listener);
        Iterator<Listener1> iter = this.listeners1.iterator();
        while (iter.hasNext()) {
            Listener1 l = iter.next();
            if (!SafeEquals.equals((Object)name, (Object)l.name) || !SafeEquals.equals((Object)listener, (Object)l.listener)) continue;
            this.listeners.remove(l);
            this.unregisteredListeners.remove(l);
            iter.remove();
        }
    }

    @Override
    public synchronized void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbs.removeNotificationListener(name, listener);
        Iterator<Listener2> iter = this.listeners2.iterator();
        while (iter.hasNext()) {
            Listener2 l = iter.next();
            if (!SafeEquals.equals((Object)name, (Object)l.name) || !SafeEquals.equals((Object)listener, (Object)l.listener)) continue;
            this.listeners.remove(l);
            this.unregisteredListeners.remove(l);
            iter.remove();
        }
    }

    @Override
    public synchronized void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbs.removeNotificationListener(name, listener, filter, handback);
        Listener1 l = new Listener1(name, listener, filter, handback);
        this.listeners.remove(l);
        this.listeners1.remove(l);
        this.unregisteredListeners.remove(l);
    }

    private synchronized void innerRemoveNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbs.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public synchronized void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbs.removeNotificationListener(name, listener, filter, handback);
        Listener2 l = new Listener2(name, listener, filter, handback);
        this.listeners.remove(l);
        this.listeners2.remove(l);
        this.unregisteredListeners.remove(l);
    }

    private synchronized void innerRemoveNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbs.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.mbs.setAttribute(name, attribute);
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        return this.mbs.setAttributes(name, attributes);
    }

    @Override
    public synchronized void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.mbs.unregisterMBean(name);
        this.mBeans.remove(new MBean1(name, null));
        this.unregisteredMBeans.remove(new MBean1(name, null));
    }

    private synchronized void innerUnregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.mbs.unregisterMBean(name);
    }

    private class MBean1
    implements RegisteredMBean {
        private ObjectName name;
        private Object mBean;
        private int hashCode;

        public MBean1(ObjectName name, Object bean) {
            this.name = name;
            this.mBean = bean;
            HashCode hc = new HashCode();
            hc.add((Object)name);
            this.hashCode = hc.getHash();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MBean1)) {
                return false;
            }
            MBean1 mBean = (MBean1)obj;
            return SafeEquals.equals((Object)this.name, (Object)mBean.name);
        }

        @Override
        public void register() throws InstanceNotFoundException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
            PogamutMBeanServer.this.innerRegisterMBean(this.mBean, this.name);
        }

        @Override
        public void unregister() {
            try {
                PogamutMBeanServer.this.innerUnregisterMBean(this.name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String toString() {
            return "MBean1[name=" + this.name + ", object=" + this.mBean + "]";
        }
    }

    private class Listener2
    implements RegisteredListener {
        private ObjectName name;
        private NotificationListener listener;
        private NotificationFilter filter;
        private Object handback;
        private int hashCode;

        public Listener2(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
            this.name = name;
            this.listener = listener;
            this.filter = filter;
            this.handback = handback;
            HashCode hc = new HashCode();
            hc.add((Object)name);
            hc.add((Object)listener);
            hc.add((Object)filter);
            hc.add(handback);
            this.hashCode = hc.getHash();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Listener2)) {
                return false;
            }
            Listener2 l = (Listener2)o;
            return SafeEquals.equals((Object)this.name, (Object)l.name) && SafeEquals.equals((Object)this.listener, (Object)l.listener) && SafeEquals.equals((Object)this.filter, (Object)l.filter) && SafeEquals.equals((Object)this.handback, (Object)l.handback);
        }

        @Override
        public void unregister() {
            try {
                PogamutMBeanServer.this.innerRemoveNotificationListener(this.name, this.listener, this.filter, this.handback);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void register() throws InstanceNotFoundException {
            PogamutMBeanServer.this.innerAddNotificationListener(this.name, this.listener, this.filter, this.handback);
        }

        public String toString() {
            return "Listener2[name=" + this.name + ", listener=" + this.listener + "]";
        }
    }

    private class Listener1
    implements RegisteredListener {
        private ObjectName name;
        private ObjectName listener;
        private NotificationFilter filter;
        private Object handback;
        private int hashCode;

        public Listener1(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) {
            this.name = name;
            this.listener = listener;
            this.filter = filter;
            this.handback = handback;
            HashCode hc = new HashCode();
            hc.add((Object)name);
            hc.add((Object)listener);
            hc.add((Object)filter);
            hc.add(handback);
            this.hashCode = hc.getHash();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Listener1)) {
                return false;
            }
            Listener1 l = (Listener1)o;
            return SafeEquals.equals((Object)this.name, (Object)l.name) && SafeEquals.equals((Object)this.listener, (Object)l.listener) && SafeEquals.equals((Object)this.filter, (Object)l.filter) && SafeEquals.equals((Object)this.handback, (Object)l.handback);
        }

        @Override
        public void unregister() {
            try {
                PogamutMBeanServer.this.innerRemoveNotificationListener(this.name, this.listener, this.filter, this.handback);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void register() throws InstanceNotFoundException {
            PogamutMBeanServer.this.innerAddNotificationListener(this.name, this.listener, this.filter, this.handback);
        }

        public String toString() {
            return "Listener1[name=" + this.name + ", listener=" + this.listener + "]";
        }
    }

    private static interface RegisteredMBean {
        public void register() throws InstanceNotFoundException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException;

        public void unregister();
    }

    private static interface RegisteredListener {
        public void register() throws InstanceNotFoundException;

        public void unregister();
    }
}

