/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.jmx;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.MockAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.jmx.proxy.AgentJMXProxy;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStatePaused;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStatePausing;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateResuming;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateStarting;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateStopped;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateStopping;
import cz.cuni.amis.pogamut.base.agent.state.level3.IAgentStateResumed;
import cz.cuni.amis.pogamut.base.agent.state.level3.IAgentStateStarted;
import cz.cuni.amis.pogamut.base.component.bus.ComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.flag.FlagListener;
import cz.cuni.amis.utils.flag.IFlag;
import cz.cuni.amis.utils.flag.WaitForFlagChange;
import cz.cuni.amis.utils.token.IToken;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.management.ObjectInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test02_AgentJMXProxy_Repeated
extends BaseTest {
    AbstractAgent agent = null;
    ObjectInstance agentObjectInstance = null;
    AgentJMXProxy agentProxy = null;
    IToken token;
    Queue<Class> expectingStateChanges = new LinkedList<Class>();
    private String agentAddress;

    @Before
    public void setUp() {
        AgentId agentId = new AgentId("Test01_AgentJMXProxy");
        this.token = agentId;
        AgentLogger logger = new AgentLogger((IAgentId)agentId);
        logger.addDefaultConsoleHandler();
        logger.setLevel(Level.ALL);
        ComponentBus bus = new ComponentBus((IAgentLogger)logger);
        this.agent = new MockAgent((IAgentId)agentId, (IComponentBus)bus, (IAgentLogger)logger);
        this.agentAddress = this.agent.getJMX().enableJMX();
    }

    @After
    public void tearDown() {
        Pogamut.getPlatform().close();
    }

    @Test
    public void testAgentNotifications() {
        int repetitions = 5;
        FlagListener<IAgentState> stateListener = new FlagListener<IAgentState>(){

            public void flagChanged(IAgentState changedValue) {
                Class cls = Test02_AgentJMXProxy_Repeated.this.expectingStateChanges.peek();
                if (cls.isAssignableFrom(changedValue.getClass())) {
                    System.out.println("CONSUMING " + cls);
                    Test02_AgentJMXProxy_Repeated.this.expectingStateChanges.poll();
                }
            }
        };
        this.agentProxy = new AgentJMXProxy(this.agentAddress);
        Assert.assertTrue((String)"name should be Test01_AgentJMXProxy", (boolean)this.agentProxy.getName().equals("Test01_AgentJMXProxy"));
        Assert.assertTrue((String)("token should be " + this.token.getToken()), (boolean)this.token.getToken().equals(this.agentProxy.getComponentId().getToken()));
        this.agentProxy.getState().addListener((FlagListener)stateListener);
        for (int i = 0; i < 5; ++i) {
            if (i == 0) {
                this.expectingStateChanges.add(IAgentStateStarting.class);
                this.expectingStateChanges.add(IAgentStateStarted.class);
                this.agent.start();
            } else {
                this.agent.start();
                this.agentProxy = new AgentJMXProxy(this.agentAddress);
                Assert.assertTrue((String)"name should be Test01_AgentJMXProxy", (boolean)this.agentProxy.getName().equals("Test01_AgentJMXProxy"));
                Assert.assertTrue((String)("token should be " + this.token.getToken()), (boolean)this.token.getToken().equals(this.agentProxy.getComponentId().getToken()));
                this.agentProxy.getState().addListener((FlagListener)stateListener);
            }
            this.expectingStateChanges.add(IAgentStatePausing.class);
            this.expectingStateChanges.add(IAgentStatePaused.class);
            this.expectingStateChanges.add(IAgentStateResuming.class);
            this.expectingStateChanges.add(IAgentStateResumed.class);
            this.expectingStateChanges.add(IAgentStatePausing.class);
            this.expectingStateChanges.add(IAgentStatePaused.class);
            this.expectingStateChanges.add(IAgentStateResuming.class);
            this.expectingStateChanges.add(IAgentStateResumed.class);
            this.expectingStateChanges.add(IAgentStateStopping.class);
            this.expectingStateChanges.add(IAgentStateStopped.class);
            this.agent.pause();
            this.agent.resume();
            this.agent.pause();
            this.agent.resume();
            this.agent.stop();
            IAgentState result = (IAgentState)new WaitForFlagChange((IFlag)this.agentProxy.getState(), (WaitForFlagChange.IAccept)new WaitForFlagChange.IAccept<IAgentState>(){

                public boolean accept(IAgentState flagValue) {
                    return flagValue instanceof IAgentStateStopped;
                }
            }).await(10000L, TimeUnit.MILLISECONDS);
            if (result == null || !(result instanceof IAgentStateStopped)) {
                Assert.fail((String)("Failed to sense " + (i + 1) + "th IAgentStateStopped in 10 secs."));
            }
            if (this.expectingStateChanges.size() <= 0) continue;
            System.out.println(i + 1 + ". agent should have gone through all expected states, remaining state changes " + this.expectingStateChanges.size() + ".");
            Assert.fail((String)(i + 1 + ". agent should have gone through all expected states, remaining state changes " + this.expectingStateChanges.size() + "."));
        }
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) throws Exception {
        Test02_AgentJMXProxy_Repeated test = new Test02_AgentJMXProxy_Repeated();
        test.setUp();
        test.testAgentNotifications();
        test.tearDown();
    }
}

