/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.worldview;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.LifecycleBus;
import cz.cuni.amis.pogamut.base.component.stub.component.ComponentStub;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.multi.agent.ITeamedAgentId;
import cz.cuni.amis.pogamut.multi.agent.impl.TeamedAgentId;
import cz.cuni.amis.pogamut.multi.communication.worldview.ILocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.ISharedWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.BatchAwareLocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.BatchAwareSharedWorldView;
import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKey;
import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKeyManager;
import cz.cuni.amis.pogamut.multi.worldview.events.BatchBeginEventStub;
import cz.cuni.amis.pogamut.multi.worldview.events.BatchEndEventStub;
import cz.cuni.amis.pogamut.multi.worldview.objects.CheckInstances;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestCompositeObject;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestCompositeObjectMessage;
import cz.cuni.amis.pogamut.multi.worldview.stub.BatchAwareLocalWVStub;
import cz.cuni.amis.pogamut.multi.worldview.stub.BatchAwareSharedWVStub;
import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Ignore;
import org.junit.Test;

public class BatchAwareWorldViewTest
extends BaseTest {
    protected BatchAwareSharedWVStub createSWV() {
        return new BatchAwareSharedWVStub(log);
    }

    public synchronized void runTest(int agents, int logicCycles, long logicDuration, int objectsPerBatch, long batchDuration, long timeoutMillis) {
        log.info("======== TEST ========");
        log.info("Agents:            " + agents);
        log.info("Logic cycles:      " + logicCycles);
        log.info("Logic duration:    " + logicDuration + " ms");
        log.info("Objects per batch: " + objectsPerBatch + " ms");
        log.info("Batch duration:    " + batchDuration + " ms");
        log.info("-------- INIT --------");
        log.info("Shared worldview...");
        BatchAwareSharedWVStub swv = this.createSWV();
        log.info("Runner...");
        AgentRunnerStub runner = new AgentRunnerStub(agents, swv, logicCycles, logicDuration, objectsPerBatch, batchDuration);
        log.info("------ TESTING! ------");
        runner.run(timeoutMillis);
        if (runner.failure) {
            if (runner.cause != null) {
                throw new PogamutException("TEST FAILED", runner.cause, log, (Object)this);
            }
            throw new PogamutException("TEST FAILED", log, (Object)this);
        }
        runner.destroy();
        runner = null;
        swv = null;
        CheckInstances.waitGCTotal(agents);
        this.testOk();
    }

    @Ignore
    @Test
    public void exampleTest() {
        this.runTest(1, 10, 100L, 10, 50L, 10000000L);
    }

    @After
    public void afterTest() {
        try {
            TimeKeyManager.get().unlockAll();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            TimeKey.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Logger access$200() {
        return log;
    }

    static /* synthetic */ Logger access$300() {
        return log;
    }

    static /* synthetic */ Logger access$400() {
        return log;
    }

    static /* synthetic */ Logger access$500() {
        return log;
    }

    private class AgentRunnerStub {
        private TeamAgentStub[] agents;
        private FlagListener<Boolean>[] listeners;
        private Object eventMutex = new Object();
        private CountDownLatch latch;
        private boolean failure = false;
        private Throwable cause = null;
        private Flag<Boolean> isRunning = new Flag((Object)false);

        public AgentRunnerStub(int agentNum, BatchAwareSharedWorldView swv, int logicCycles, long logicDuration, int objectsPerBatch, long batchDuration) {
            this.agents = new TeamAgentStub[agentNum];
            this.listeners = new FlagListener[agentNum];
            this.latch = new CountDownLatch(agentNum);
            for (int i = 0; i < this.agents.length; ++i) {
                final int curAgent = i;
                this.agents[i] = new TeamAgentStub(i, swv, logicCycles, logicDuration, objectsPerBatch, batchDuration);
                this.listeners[i] = new FlagListener<Boolean>(){

                    public void flagChanged(Boolean changedValue) {
                        if (!changedValue.booleanValue()) {
                            if (AgentRunnerStub.this.agents[curAgent].failure) {
                                AgentRunnerStub.this.failure(curAgent);
                            } else {
                                AgentRunnerStub.this.latch.countDown();
                            }
                        }
                    }
                };
                this.agents[i].isRunning.addListener(this.listeners[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void failure(int agentNum) {
            Object object = this.eventMutex;
            synchronized (object) {
                if (this.failure) {
                    return;
                }
                if (this.cause == null) {
                    this.cause = this.agents[agentNum].cause;
                }
                log.severe("Agent[" + agentNum + "] FAILED!");
                this.failure = true;
            }
            try {
                for (TeamAgentStub agent : this.agents) {
                    if (agent == null) continue;
                    try {
                        agent.kill();
                    }
                    catch (Exception e) {
                        log.severe(ExceptionToString.process((String)("Exception killing " + agent.agentId), (Throwable)e));
                    }
                }
            }
            finally {
                while (this.latch.getCount() > 0L) {
                    this.latch.countDown();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void failure(String message) {
            Object object = this.eventMutex;
            synchronized (object) {
                if (this.failure) {
                    return;
                }
                if (this.cause == null) {
                    this.cause = new RuntimeException(message);
                }
                log.severe("AgentRunner FAILED!");
                this.failure = true;
            }
            try {
                for (TeamAgentStub agent : this.agents) {
                    if (agent == null) continue;
                    try {
                        agent.kill();
                    }
                    catch (Exception e) {
                        log.severe(ExceptionToString.process((String)("Exception killing " + agent.agentId), (Throwable)e));
                    }
                }
            }
            finally {
                while (this.latch.getCount() > 0L) {
                    this.latch.countDown();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run(long timeout) {
            try {
                this.isRunning.setFlag((Object)true);
                Object object = this.eventMutex;
                synchronized (object) {
                    for (int i = 0; i < this.agents.length; ++i) {
                        this.agents[i].start();
                    }
                }
                try {
                    this.latch.await(timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    log.severe("INTERRUPTED!");
                    this.failure = true;
                    if (this.cause == null) {
                        this.cause = new PogamutInterruptedException((Throwable)e, (Object)this);
                        throw (PogamutInterruptedException)this.cause;
                    }
                    throw new PogamutException("Interrupted!", this.cause, (Object)this);
                }
                if (this.latch.getCount() > 0L) {
                    this.failure("TIMEOUT!");
                }
            }
            catch (Exception e) {
                this.failure("RUNNER EXCEPTION!");
            }
            finally {
                int i = 0;
                for (TeamAgentStub agent : this.agents) {
                    if (agent != null && this.listeners[i] != null) {
                        agent.isRunning.removeListener(this.listeners[i]);
                    }
                    if (agent != null) {
                        agent.kill();
                    }
                    ++i;
                }
                this.isRunning.setFlag((Object)false);
            }
        }

        public void destroy() {
            for (int i = 0; i < this.agents.length; ++i) {
                TeamAgentStub agent = this.agents[i];
                if (agent == null) continue;
                this.agents[i] = null;
            }
        }
    }

    protected class TeamAgentStub {
        private ITeamedAgentId agentId;
        private BatchAwareLocalWorldView agentWV;
        private ComponentStub starter;
        private AgentEventGeneratorStub eventGenerator;
        private AgentLogicStub logic;
        private Object eventMutex = new Object();
        private Thread eventThread;
        private Thread logicThread;
        private volatile Flag<Boolean> isRunning = new Flag((Object)false);
        private volatile boolean failure = false;
        private volatile Throwable cause = null;
        private FlagListener<Boolean> eventListener = new FlagListener<Boolean>(){

            public void flagChanged(Boolean changedValue) {
                if (!changedValue.booleanValue()) {
                    if (((Boolean)TeamAgentStub.this.isRunning.getFlag()).booleanValue() && TeamAgentStub.this.eventGenerator.failure) {
                        if (TeamAgentStub.this.cause == null) {
                            TeamAgentStub.this.cause = TeamAgentStub.this.eventGenerator.cause;
                        }
                        TeamAgentStub.this.failure = true;
                    }
                    TeamAgentStub.this.kill();
                }
            }
        };
        private FlagListener<Boolean> logicListener = new FlagListener<Boolean>(){

            public void flagChanged(Boolean changedValue) {
                if (!changedValue.booleanValue()) {
                    if (TeamAgentStub.this.logic.failure) {
                        if (TeamAgentStub.this.cause == null) {
                            TeamAgentStub.this.cause = TeamAgentStub.this.logic.cause;
                        }
                        TeamAgentStub.this.failure = true;
                    }
                    TeamAgentStub.this.kill();
                }
            }
        };
        boolean killing = false;

        public TeamAgentStub(int agentNum, BatchAwareSharedWorldView swv, int logicCycles, long logicDuration, int objectsPerBatch, long batchDuration) {
            this.agentId = new TeamedAgentId("Agent" + agentNum, "RED");
            AgentLogger log = new AgentLogger((IAgentId)this.agentId);
            log.setLevel(Level.ALL);
            log.addDefaultConsoleHandler();
            LifecycleBus bus = new LifecycleBus((IAgentLogger)log);
            this.starter = new ComponentStub((IAgentLogger)log, (IComponentBus)bus);
            this.agentWV = new BatchAwareLocalWVStub(new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IComponent)this.starter), (ILifecycleBus)bus, (IAgentLogger)log, (ISharedWorldView)swv, this.agentId);
            this.eventGenerator = new AgentEventGeneratorStub(objectsPerBatch, batchDuration, (ILocalWorldView)this.agentWV);
            this.logic = new AgentLogicStub(logicCycles, objectsPerBatch, logicDuration, this.agentWV);
        }

        public ITeamedAgentId getAgentId() {
            return this.agentId;
        }

        public BatchAwareLocalWorldView getLocalWV() {
            return this.agentWV;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            Object object = this.eventMutex;
            synchronized (object) {
                if (((Boolean)this.isRunning.getFlag()).booleanValue()) {
                    return;
                }
                this.starter.getController().manualStart("Test");
                this.eventGenerator.shouldRun = true;
                this.logic.shouldRun = true;
                this.eventThread = new Thread((Runnable)this.eventGenerator, this.agentId.getToken() + "-EventGeneratorThread");
                this.logicThread = new Thread((Runnable)this.logic, this.agentId.getToken() + "-LogicThread");
                this.eventGenerator.isRunning.addListener(this.eventListener);
                this.logic.isRunning.addListener(this.logicListener);
                this.isRunning.setFlag((Object)true);
                this.failure = false;
                this.eventThread.start();
                this.logicThread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void kill() {
            if (!((Boolean)this.isRunning.getFlag()).booleanValue()) {
                return;
            }
            Object object = this.eventMutex;
            synchronized (object) {
                if (this.killing) {
                    return;
                }
                this.killing = true;
            }
            try {
                log.info(this.agentId + ": Shutting down...");
                this.eventGenerator.shouldRun = false;
                if (this.failure) {
                    this.eventGenerator.isRunning.removeListener(this.eventListener);
                    this.eventThread.interrupt();
                } else {
                    log.info(this.agentId + ": Waiting 2 secs for EventGenerator shutdown...");
                    this.eventGenerator.isRunning.waitFor(2000L, (Object[])new Boolean[]{false});
                    this.eventGenerator.isRunning.removeListener(this.eventListener);
                    if (((Boolean)this.eventGenerator.isRunning.getFlag()).booleanValue()) {
                        log.severe(this.agentId + ": FAILURE! EventGenerator still running!");
                        this.failure = true;
                        this.eventThread.interrupt();
                    } else {
                        log.info(this.agentId + ": EventGenerator shut down.");
                    }
                }
                this.logic.shouldRun = false;
                if (this.failure) {
                    this.logic.isRunning.removeListener(this.logicListener);
                    this.logicThread.interrupt();
                } else {
                    log.info(this.agentId + ": Waiting 2 secs for Logic shutdown...");
                    this.logic.isRunning.waitFor(2000L, (Object[])new Boolean[]{false});
                    this.logic.isRunning.removeListener(this.logicListener);
                    if (((Boolean)this.logic.isRunning.getFlag()).booleanValue()) {
                        log.severe(this.agentId + ": FAILURE! Logic still running!");
                        this.failure = true;
                        this.logicThread.interrupt();
                    } else {
                        log.info(this.agentId + ": Logic shut down.");
                    }
                }
                if (!this.failure) {
                    try {
                        log.info(this.agentId + ": Generating additional batch.");
                        this.eventGenerator.generateNext();
                        log.info(this.agentId + ": Consuming additionally generated batches with another logic-iteration.");
                        this.logic.consumeNext();
                    }
                    catch (Exception e) {
                        log.severe(ExceptionToString.process((String)"Failed!", (Throwable)e));
                        this.failure = true;
                    }
                }
                this.starter.getController().manualStop("Stop");
            }
            finally {
                try {
                    this.isRunning.setFlag((Object)false);
                }
                finally {
                    this.killing = false;
                }
            }
        }
    }

    protected class AgentLogicStub
    implements Runnable {
        private long logicDuration;
        private TeamedAgentId agentId;
        private volatile boolean shouldRun = true;
        private volatile Flag<Boolean> isRunning = new Flag((Object)false);
        private volatile boolean failure = false;
        private volatile Throwable cause = null;
        private long currentTime = 0L;
        private int runs;
        private int run;
        private BatchAwareLocalWorldView localWV;
        private int objectsPerBatch;

        public AgentLogicStub(int runs, int objectsPerBatch, long logicDuration, BatchAwareLocalWorldView localWV) {
            this.runs = runs;
            this.objectsPerBatch = objectsPerBatch;
            this.logicDuration = logicDuration;
            this.agentId = (TeamedAgentId)localWV.getAgentId();
            this.localWV = localWV;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.info(this.agentId + "-Logic: STARTING LOGIC");
            this.isRunning.setFlag((Object)true);
            try {
                this.run = 0;
                while (this.run < this.runs && this.shouldRun) {
                    this.consumeNext();
                }
            }
            catch (Exception e) {
                this.cause = e;
                this.failure = true;
                log.severe(ExceptionToString.process((String)(this.agentId + "-Logic: FAILURE."), (Throwable)e));
            }
            finally {
                this.isRunning.setFlag((Object)false);
            }
            log.info(this.agentId + "-Logic: END");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consumeNext() {
            ++this.run;
            log.info(this.agentId + "-Logic[Run=" + this.run + "/" + this.runs + "]: LOGIC ITERATION");
            log.info(this.agentId + "-Logic[Run=" + this.run + "/" + this.runs + "]: Locking worldview...");
            this.localWV.lock();
            try {
                this.currentTime = this.localWV.getCurrentTimeKey().getTime();
                log.info(this.agentId + "-Logic[Run=" + this.run + "/" + this.runs + ", Time=" + this.currentTime + "]: Worldview locked.");
                for (int i = 0; i < this.objectsPerBatch; ++i) {
                    WorldObjectId objectId = WorldObjectId.get((String)("TestObject[" + i + "]"));
                    TestCompositeObject obj = (TestCompositeObject)this.localWV.get(objectId);
                    BatchAwareWorldViewTest.this.assertTrue(this.agentId + "-Logic[Run=" + this.run + "/" + this.runs + ", Time=" + this.currentTime + "]: " + objectId + " must exist! But is null...", obj != null);
                    long sharedLong = (long)(i + 1000) + this.currentTime;
                    String sharedString = "ShS:" + this.agentId.getTeamId().toString() + "[" + i + "]" + "(" + this.currentTime + ")";
                    long localLong = (long)i + this.currentTime;
                    String localString = "LS:" + this.agentId.getTeamId().toString() + "[" + i + "]" + "(" + this.currentTime + ")";
                    long staticLong = i;
                    String staticString = "StaticString[" + i + "]";
                    BatchAwareWorldViewTest.this.assertTrue(this.agentId + "-Logic[Run=" + this.run + "/" + this.runs + ", Time=" + this.currentTime + "]: SharedString fail!" + BaseTest.NEW_LINE + "        Expected: " + sharedString + ", " + BaseTest.NEW_LINE + "        Got:      " + obj.getSharedString() + BaseTest.NEW_LINE + "        On:       " + obj, obj.getSharedString().equals(sharedString));
                    BatchAwareWorldViewTest.this.assertTrue(this.agentId + "-Logic[Run=" + this.run + "/" + this.runs + ", Time=" + this.currentTime + "]: SharedLong fail!" + BaseTest.NEW_LINE + "        Expected: " + sharedLong + ", " + BaseTest.NEW_LINE + "        Got:      " + obj.getSharedLong() + BaseTest.NEW_LINE + "        On:       " + obj, obj.getSharedLong() == sharedLong);
                    BatchAwareWorldViewTest.this.assertTrue(this.agentId + "-Logic[Run=" + this.run + "/" + this.runs + ", Time=" + this.currentTime + "]: LocalString fail!" + BaseTest.NEW_LINE + "        Expected: " + localString + ", " + BaseTest.NEW_LINE + "        Got:      " + obj.getLocalString() + BaseTest.NEW_LINE + "        On:       " + obj, obj.getLocalString().equals(localString));
                    BatchAwareWorldViewTest.this.assertTrue(this.agentId + "-Logic[Run=" + this.run + "/" + this.runs + ", Time=" + this.currentTime + "]: LocalLong fail!" + BaseTest.NEW_LINE + "        Expected: " + localLong + ", " + BaseTest.NEW_LINE + "        Got:      " + obj.getLocalLong() + BaseTest.NEW_LINE + "        On:       " + obj, obj.getLocalLong() == (long)i + this.currentTime);
                    BatchAwareWorldViewTest.this.assertTrue(this.agentId + "-Logic[Run=" + this.run + "/" + this.runs + ", Time=" + this.currentTime + "]: StaticString fail!" + BaseTest.NEW_LINE + "        Expected: " + staticString + ", " + BaseTest.NEW_LINE + "        Got:      " + obj.getStaticString() + BaseTest.NEW_LINE + "        On:       " + obj, obj.getStaticString().equals(staticString));
                    BatchAwareWorldViewTest.this.assertTrue(this.agentId + "-Logic[Run=" + this.run + "/" + this.runs + ", Time=" + this.currentTime + "]: StaticLong fail!" + BaseTest.NEW_LINE + "        Expected: " + staticLong + ", " + BaseTest.NEW_LINE + "        Got:      " + obj.getStaticLong() + BaseTest.NEW_LINE + "        On:       " + obj, obj.getStaticLong() == staticLong);
                }
                log.info(this.agentId + "-Logic: Simulating logic " + this.logicDuration + " ms...");
                try {
                    Thread.sleep(this.logicDuration);
                }
                catch (InterruptedException e) {
                    throw new PogamutInterruptedException((Throwable)e, (Object)this);
                }
            }
            finally {
                this.localWV.unlock();
            }
        }
    }

    protected class AgentEventGeneratorStub
    implements Runnable {
        private EventGeneratorStub eventGenerator;
        private long batchDuration;
        private TeamedAgentId agentId;
        private volatile boolean shouldRun = true;
        private volatile Flag<Boolean> isRunning = new Flag((Object)false);
        private volatile boolean failure = false;
        private volatile Throwable cause = null;
        private long currentTime = 0L;

        public AgentEventGeneratorStub(int objectPerBatch, long batchDuration, ILocalWorldView localWV) {
            this.eventGenerator = new EventGeneratorStub(objectPerBatch, localWV);
            this.batchDuration = batchDuration;
            this.agentId = (TeamedAgentId)localWV.getAgentId();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void generateNext() {
            ++this.currentTime;
            this.eventGenerator.generateEvents(this.currentTime);
        }
    }

    protected class EventGeneratorStub {
        private int objectsPerBatch;
        private ILocalWorldView localWV;
        private TeamedAgentId agentId;

        public EventGeneratorStub(int objectsPerBatch, ILocalWorldView localWV) {
            this.objectsPerBatch = objectsPerBatch;
            this.localWV = localWV;
            this.agentId = (TeamedAgentId)localWV.getAgentId();
        }

        public void generateEvents(long time) {
            log.info(this.agentId + "-EventGenerator: generating events [Time=" + time + "].");
            this.localWV.notify((IWorldChangeEvent)new BatchBeginEventStub(time));
            for (int i = 0; i < this.objectsPerBatch; ++i) {
                WorldObjectId id = WorldObjectId.get((String)("TestObject[" + i + "]"));
                TestCompositeObjectMessage obj = new TestCompositeObjectMessage(id, time, "LS:" + this.agentId.getTeamId().toString() + "[" + i + "]" + "(" + time + ")", (long)i + time, "ShS:" + this.agentId.getTeamId().toString() + "[" + i + "]" + "(" + time + ")", (long)(i + 1000) + time, "StaticString[" + i + "]", Long.valueOf(i));
                this.localWV.notify((IWorldChangeEvent)obj.createUpdateEvent(time, this.agentId.getTeamId()));
            }
            this.localWV.notify((IWorldChangeEvent)new BatchEndEventStub(time));
            log.info(this.agentId + "-EventGenerator: generated " + this.objectsPerBatch + " object-events.");
        }
    }
}

