/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.stub.component;

import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEventListener;
import cz.cuni.amis.pogamut.base.component.stub.component.CheckEvent;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;

public class AutoCheckComponent
implements IComponent {
    private static int counter = 0;
    private Token token;
    private List<CheckEvent> expect = new LinkedList<CheckEvent>();
    private IComponentBus bus;
    private LogCategory log;
    private boolean exactOrder = true;
    private IComponentEventListener<IComponentEvent> listener = new IComponentEventListener<IComponentEvent>(){

        public void notify(IComponentEvent event) {
            if (AutoCheckComponent.this.log.isLoggable(Level.INFO)) {
                AutoCheckComponent.this.log.info("Got event: " + event);
            }
            if (AutoCheckComponent.this.expect.size() == 0) {
                throw new RuntimeException("No event expected, but " + event.getClass() + " from " + event.getSource() + " came.");
            }
            if (AutoCheckComponent.this.exactOrder) {
                ((CheckEvent)AutoCheckComponent.this.expect.get(0)).check(event);
                AutoCheckComponent.this.expect.remove(0);
            } else {
                for (int i = 0; i < AutoCheckComponent.this.expect.size(); ++i) {
                    if (!((CheckEvent)AutoCheckComponent.this.expect.get(i)).checkNoException(event)) continue;
                    AutoCheckComponent.this.expect.remove(i);
                    return;
                }
                Assert.fail((String)("Did not expect event of class " + event.getClass() + " from " + event.getSource() + "."));
            }
        }
    };

    public AutoCheckComponent(IAgentLogger logger, IComponentBus bus) {
        this(logger, bus, new CheckEvent[0]);
    }

    public AutoCheckComponent(IAgentLogger logger, IComponentBus bus, CheckEvent ... events) {
        this.token = Tokens.get((String)("AutoCheckComponent" + counter++));
        this.log = logger.getCategory((IComponent)this);
        NullCheck.check((Object)this.log, (String)"log initialization");
        this.expect(events);
        this.bus = bus;
        this.bus.addEventListener(IComponentEvent.class, this.listener);
        this.bus.register((IComponent)this);
    }

    public void expect(CheckEvent ... events) {
        for (CheckEvent event : events) {
            this.expect(event);
        }
    }

    public void expect(CheckEvent event) {
        this.expect.add(event);
    }

    public int getExpectSize() {
        return this.expect.size();
    }

    public IToken getComponentId() {
        return this.token;
    }

    public Logger getLog() {
        return this.log;
    }

    public boolean isExactOrder() {
        return this.exactOrder;
    }

    public void setExactOrder(boolean exactOrder) {
        this.exactOrder = exactOrder;
    }

    public String toString() {
        return this.getComponentId().getToken();
    }

    public void checkExpectEmpty() {
        Assert.assertTrue((String)"should not expect any events", (this.getExpectSize() == 0 ? 1 : 0) != 0);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Does not expecting any more events.");
        }
    }
}

