package cz.cuni.amis.pogamut.multi.utils.timekey;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

import junit.framework.Assert;

import org.junit.Test;

import cz.cuni.amis.pogamut.multi.utils.exception.TimeKeyNotLockedException;
import cz.cuni.amis.pogamut.multi.worldview.objects.CheckInstances;
import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
				
public class Test02_TimeKeyManager extends BaseTest {
	
	public static Random r = new Random( System.currentTimeMillis() );
	
	private static boolean failure = false;
		
	private class Locker implements Runnable
	{
		
		HashSet<Long> locks = new HashSet<Long>();
		
		List<Long> toLock = new ArrayList<Long>();

		private int runs;
		private int id;
	
		public Locker(int runs, int id)
		{
			this.runs = runs;
			this.id = id;
			for (long key = 0; key < runs; ++key) {
				toLock.add(key);
			}
			Collections.shuffle(toLock);
		}
		
		protected void makeLock(long l)
		{
			if ( locks.contains(l))
			{
				return;
			}
			log.fine("Locking : " + l);
			TimeKeyManager.get().lock( l );
			locks.add(l);
		}
		
		protected void removeLock(long l)
		{
			if ( locks.contains(l) )
			{
				locks.remove(l);
				log.fine("Unlocking : " + l );
				try {
					TimeKeyManager.get().unlock( l );
				} catch (TimeKeyNotLockedException e) {
					failure = true;
					log.severe("Trying to unlock not locked TimeKey : " + l );
					throw new RuntimeException("Trying to unlock not locked TimeKey : " + l);
				}
			}
		}
		
		protected void checkLocks()
		{
			for ( Long l : locks)
			{
				if ( ! TimeKeyManager.get().isLocked( l ))
				{
					failure = true;
					log.severe("TimeKey " + l + " should be locked, but is not!!!");
					throw new RuntimeException("TimeKey " + l + " should be locked, but is not!!!");
				}
			}	
		}
		
		protected void removeLocks()
		{
			log.info("Thread " + id + " : Removing locks");
			
			while (locks.size() > 0) {
				removeLock(locks.iterator().next());				
				checkLocks();
			}
			locks.clear();
		}
		
		@Override
		public void run() {
			while ( runs > 0 )
			{
				if ( runs % 20 == 0)
				{
					log.info( "Thread " + id + ": " + runs + " runs remaining");
				}
				long key = toLock.remove(toLock.size()-1);
				makeLock(key);
				checkLocks();
				--runs;
			}
			removeLocks();
			log.info("Thread " + id + " : Finished.");
		}
		
	}
	
	@Test(timeout=60000)
	public void lockUnlockTest() 
	{
		int thrds = 1;
		int runs = 10;
		Thread[] threads = new Thread[thrds];
		for ( int i = 0; i < thrds; ++i)
		{
			threads[i] = new Thread( new Locker(runs, i));
		}
		for ( Thread t : threads)
		{
			t.start();
		}
		for ( Thread t : threads)
		{
			try {
				t.join();
			} catch (InterruptedException e) {
				throw new PogamutInterruptedException(e, this);
			}
		}
		
		if (failure) {
			assertFail("There was a failure in the test!");
		}
		
		log.info("Locked: " + TimeKeyManager.get().getHeldKeysStr());
		for ( long l = -1000; l < 1000; ++l ) {
			if ( TimeKeyManager.get().isLocked( l )) {
				assertFail(" TimeKey  " + l + " still locked");
			}			
		}
		
		threads = null;
		CheckInstances.waitGCTotal();
		
		System.out.println("---/// TEST OK ///---");
	}
	
	@Test(timeout=300000)
	public void lockUnlockTest2() 
	{
		int thrds = 20;
		int runs = 1000;
		Thread[] threads = new Thread[thrds];
		for ( int i = 0; i < thrds; ++i)
		{
			threads[i] = new Thread( new Locker(runs, i));
		}
		for ( Thread t : threads)
		{
			t.start();
		}
		for ( Thread t : threads)
		{
			try {
				t.join();
			} catch (InterruptedException e) {
				throw new PogamutInterruptedException(e, this);
			}
		}
		
		if (failure) {
			assertFail("There was a failure in the test!");
		}
		
		log.info("Locked: " + TimeKeyManager.get().getHeldKeysStr());
		for ( long l = -1000; l < 1000; ++l ) {
			if ( TimeKeyManager.get().isLocked( l )) {
				assertFail(" TimeKey  " + l + " still locked");
			}			
		}
		
		threads = null;
		CheckInstances.waitGCTotal();
		
		System.out.println("---/// TEST OK ///---");
	}

}
