/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.worldview;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.LifecycleBus;
import cz.cuni.amis.pogamut.base.component.stub.component.ComponentStub;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.multi.agent.ITeamedAgentId;
import cz.cuni.amis.pogamut.multi.agent.impl.TeamId;
import cz.cuni.amis.pogamut.multi.agent.impl.TeamedAgentId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ICompositeWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.ISharedWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.EventDrivenLocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.EventDrivenSharedWorldView;
import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKey;
import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKeyManager;
import cz.cuni.amis.pogamut.multi.worldview.objects.CheckInstances;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestCompositeObjectMessage;
import cz.cuni.amis.pogamut.multi.worldview.stub.EventDrivenLocalWorldViewStub;
import cz.cuni.amis.pogamut.multi.worldview.stub.EventDrivenSharedWorldViewStub;
import cz.cuni.amis.tests.BaseTest;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Test;

public class Test01_SharedWorldViewMultiAgent
extends BaseTest {
    static EventDrivenSharedWorldView sharedWV;
    static Logger globalLogger;

    public static void createShared() {
        globalLogger = Logger.getLogger("globalLogger");
        ConsoleHandler handler = new ConsoleHandler();
        globalLogger.addHandler(handler);
        handler.setLevel(Level.INFO);
        globalLogger.setLevel(Level.INFO);
        sharedWV = new EventDrivenSharedWorldViewStub(globalLogger);
    }

    @Test(timeout=180000L)
    public void agentRunTest() {
        Test01_SharedWorldViewMultiAgent.createShared();
        TestAgent[] agents = new TestAgent[20];
        for (int i = 0; i < 20; ++i) {
            TeamedAgentId agentId = new TeamedAgentId("Agent[" + i + "]");
            if (i % 2 == 0) {
                agentId.setTeamId(new TeamId("Sudy"));
            } else {
                agentId.setTeamId(new TeamId("Lichy"));
            }
            agents[i] = new TestAgent((ITeamedAgentId)agentId, (ISharedWorldView)sharedWV);
        }
        Thread[] threads = new Thread[20];
        for (int i = 0; i < 20; ++i) {
            System.out.println("Thread " + i + " starting...");
            Thread t = threads[i] = new Thread(agents[i]);
            System.out.println("Thread " + i + "created");
            try {
                t.start();
                continue;
            }
            catch (Exception e) {
                System.out.println("Exception " + e);
            }
        }
        for (Thread t : threads) {
            while (t.isAlive()) {
                try {
                    t.join(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                CheckInstances.log();
            }
        }
        threads = null;
        agents = null;
        sharedWV = null;
        try {
            CheckInstances.waitGCTotal();
        }
        catch (Exception e) {
            System.out.println("WARNING : ");
        }
        System.out.println("---/// TEST OK ///---");
    }

    @After
    public void afterTest() {
        try {
            TimeKeyManager.get().unlockAll();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            TimeKey.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class TestAgent
    implements Runnable {
        EventDrivenLocalWorldView localWV;
        ComponentStub starter;
        private ITeamedAgentId agentId;
        boolean isRunning;

        TestAgent(ITeamedAgentId agentId, ISharedWorldView sharedWV) {
            System.out.println("Constructing agent : " + agentId);
            AgentLogger logger = new AgentLogger((IAgentId)agentId);
            logger.setLevel(Level.INFO);
            logger.addDefaultConsoleHandler();
            LifecycleBus bus = new LifecycleBus((IAgentLogger)logger);
            this.starter = new ComponentStub((IAgentLogger)logger, (IComponentBus)bus);
            this.localWV = new EventDrivenLocalWorldViewStub(new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IComponent)this.starter), (ILifecycleBus)bus, (IAgentLogger)logger, sharedWV, agentId);
            this.localWV.setInitialTime(TimeKey.get((long)1L));
            this.isRunning = false;
            this.agentId = agentId;
        }

        @Override
        public void run() {
            if (!this.isRunning) {
                this.starter.getController().manualStart("Running agent " + this.localWV.getAgentId());
                System.out.println(this.localWV.getAgentId() + " running.");
                this.isRunning = true;
            }
            try {
                long time = 1L;
                for (int i = 0; i < 500; ++i) {
                    WorldObjectId id = WorldObjectId.get((String)("TestObject[" + i + "]"));
                    TestCompositeObjectMessage m = new TestCompositeObjectMessage(id, time, "LS[" + i + "]" + this.agentId.getName(), Long.valueOf(i), "SharedString[" + i + "]" + this.agentId.getTeamId().toString(), (long)i * 1000L, "StaticString[" + i + "]", (long)i + 1000L);
                    ICompositeWorldObjectUpdatedEvent event = m.createUpdateEvent(1L, this.agentId.getTeamId());
                    this.localWV.notify((IWorldChangeEvent)event);
                }
            }
            catch (Exception e) {
                System.out.println("Exception in agent " + this.localWV.getAgentId() + " : " + e);
            }
            System.out.println("Agent : " + this.localWV.getAgentId() + " finished.");
        }
    }
}

