/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging.network;

import cz.cuni.amis.pogamut.base.agent.jmx.proxy.AgentJMXProxy;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.NetworkLogManager;
import cz.cuni.amis.pogamut.base.utils.logging.network.CheckNetworkLogClient;
import cz.cuni.amis.pogamut.base.utils.logging.network.JMXNetworkLoggingAgent;
import cz.cuni.amis.pogamut.base.utils.logging.network.JMXNetworkLoggingTest;
import org.junit.Test;

public class Test05_JMXEnabledNetworkLogging
extends JMXNetworkLoggingTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() {
        try {
            double logicFrequency = 5.0;
            int logsPerCycle = 2000;
            int lifeTimeSeconds = 2;
            int logicCycles = (int)Math.ceil(logicFrequency * (double)lifeTimeSeconds);
            int totalLogsOfOneCategory = logsPerCycle * logicCycles;
            JMXNetworkLoggingAgent agent = this.createNewAgentJMX(logicFrequency, logsPerCycle, logicCycles);
            System.out.println("[INFO] Starting agent... ");
            agent.start();
            System.out.println("[INFO] Enabling agent JMX... ");
            String agentAddress = agent.getJMX().enableJMX();
            System.out.println("[INFO] Creating AgentJMXProxy... ");
            AgentJMXProxy agentProxy = new AgentJMXProxy(agentAddress);
            System.out.println("[INFO] Enabling network logging via JMX...");
            agentProxy.getLogger().addDefaultNetworkHandler();
            try {
                System.out.println("[INFO] Creating NetworkLogClient...");
                CheckNetworkLogClient logClient1 = new CheckNetworkLogClient("LogClient1-" + agent.getName(), "localhost", NetworkLogManager.getNetworkLogManager().getLoggerPort(), agent.getComponentId().getToken());
                System.out.println("[INFO] Starting NetworkLogClient...");
                logClient1.start();
                try {
                    System.out.println("[INFO]  Dropping agent logic latch, starting to send logs...");
                    agent.getLogicLatch().countDown();
                    agent.awaitState(IAgentStateDown.class);
                    logClient1.getRunning().waitFor(1000L, (Object[])new Boolean[]{false});
                    logClient1.getThroughput().check();
                    this.checkAgent(agent);
                    this.checkLogClient(logClient1, totalLogsOfOneCategory);
                }
                finally {
                    if (((Boolean)logClient1.getRunning().getFlag()).booleanValue()) {
                        logClient1.stop();
                    }
                }
            }
            catch (Throwable throwable) {
                if (agent.notInState(new Class[]{IAgentStateDown.class})) {
                    agent.kill();
                }
                throw throwable;
            }
            if (agent.notInState(new Class[]{IAgentStateDown.class})) {
                agent.kill();
            }
        }
        finally {
            Pogamut.getPlatform().close();
        }
        System.out.println("---/// TEST OK ///---");
    }
}

