package cz.cuni.amis.pogamut.multi.worldview.objects;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.utils.flag.FlagInteger;
import cz.cuni.amis.utils.flag.ImmutableFlag;

public class TestStaticObjectImpl extends TestStaticObject{

private static FlagInteger instances = new FlagInteger(0);
	
	public static ImmutableFlag<Integer> getInstances() {
		return instances.getImmutable();
	}
	
	@Override
	protected void finalize() throws Throwable {
		super.finalize();
		instances.decrement(1);
	}
	
	protected String stringVal;
	protected long longVal;
	
	public TestStaticObjectImpl(WorldObjectId id, long simTime, String staticString, long staticLong) 
	{
		super(id, simTime);
		instances.increment(1);
		this.stringVal = staticString;
		this.longVal = staticLong;
	}
	
	public TestStaticObjectImpl(TestStaticObject other)
	{
		super(other.id, other.simTime );
		instances.increment(1);
		this.stringVal = other.getStaticString();
		this.longVal = other.getStaticLong();
	}
	
	
	@Override
	public String getStaticString() {
		return stringVal;
	}

	@Override
	public long getStaticLong() {
		return longVal;
	}
	

	
}
