/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.stub.component;

import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEvent;
import cz.cuni.amis.utils.Const;
import cz.cuni.amis.utils.NullCheck;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;

public class CheckEvent {
    private List<Class> eventClasses = new ArrayList<Class>();
    private IComponent source = null;

    public CheckEvent(IComponentEvent checkEvent) {
        for (Class<?> cls : checkEvent.getClass().getInterfaces()) {
            this.eventClasses.add(cls);
        }
        this.source = checkEvent.getSource();
        NullCheck.check((Object)this.source, (String)"checkEvent.getSource()");
    }

    public CheckEvent(Class eventClass) {
        NullCheck.check((Object)eventClass, (String)"eventClass");
        this.eventClasses.add(eventClass);
    }

    public CheckEvent(Class eventClass, IComponent source) {
        NullCheck.check((Object)eventClass, (String)"eventClass");
        this.eventClasses.add(eventClass);
        this.source = source;
        NullCheck.check((Object)this.source, (String)"source");
    }

    public CheckEvent(IComponent source) {
        this.source = source;
        NullCheck.check((Object)this.source, (String)"source");
    }

    public void check(IComponentEvent event) {
        for (Class cls : this.eventClasses) {
            if (cls.isAssignableFrom(event.getClass())) continue;
            System.out.println("EXPECTED: " + cls.getName());
            if (this.source != null) {
                System.out.println("FROM: " + this.source);
            }
            System.out.println("UNEXPECTED EVENT: ");
            System.out.println(event);
            System.out.println("FROM: " + event.getSource());
            Assert.fail((String)(Const.NEW_LINE + "Expected event class: " + cls + Const.NEW_LINE + (this.source != null ? "From                : " + this.source + Const.NEW_LINE : "") + "Got class           : " + event.getClass() + Const.NEW_LINE + "From source         : " + event.getSource()));
        }
        if (this.source != null && this.source != event.getSource()) {
            System.out.println("EXPECTED: " + this.eventClasses.get(0).getName());
            if (this.source != null) {
                System.out.println("FROM: " + this.source);
            }
            System.out.println("UNEXPECTED EVENT: ");
            System.out.println(event);
            System.out.println("FROM: " + event.getSource());
            Assert.fail((String)(Const.NEW_LINE + "Event          : " + event.getClass() + Const.NEW_LINE + "Expected source: " + this.source + Const.NEW_LINE + "Got            : " + event.getSource()));
        }
    }

    public boolean checkNoException(IComponentEvent event) {
        for (Class cls : this.eventClasses) {
            if (cls.isAssignableFrom(event.getClass())) continue;
            System.out.println("EXPECTED: " + cls.getName());
            if (this.source != null) {
                System.out.println("FROM: " + this.source);
            }
            System.out.println("UNEXPECTED EVENT: ");
            System.out.println(event);
            System.out.println("FROM: " + event.getSource());
            return false;
        }
        if (this.source != null && this.source != event.getSource()) {
            System.out.println("EXPECTED: " + this.eventClasses.get(0).getName());
            if (this.source != null) {
                System.out.println("FROM: " + this.source);
            }
            System.out.println("UNEXPECTED EVENT: ");
            System.out.println(event);
            System.out.println("FROM: " + event.getSource());
            return false;
        }
        return true;
    }
}

