/*
Gamebots Pogamut derivation Copyright (c) 2010-2011, Michal Bida, Radek Pibil

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.

*/
class GBTeamGameHandler extends GBGameHandler;

var UTTeamGame teamGame;

function InitGame(string Options, out string Error )
{
	Super.InitGame(Options, Error);

	teamGame = UTTeamGame(game);

	//Overriding balancing teams here - setting to false;
	teamGame.bPlayersBalanceTeams = false;
}

function bool isCorrectOwnerType()
{
	return super.isCorrectOwnerType() && Owner.IsA('UTTeamGame');
}

function string GetGameInfo()
{
	local string outStr;

	outStr = " {GoalTeamScore " $ utGame.GoalScore $
		"} {TimeLimit " $ utGame.TimeLimit $
		"} {MaxTeams 2" $
		"} {MaxTeamSize " $ FFloor(utGame.MaxPlayersAllowed / 2) $
		"}";

	return outStr;
}

//Main function for adding bot to the game (also creates controller)
function RemoteBot AddRemoteBot
(
	BotConnection theConnection,
	string clientName,
	int TeamNum,
	optional string className,
	optional string DesiredSkin,
	optional float DesiredSkill,
	optional bool ShouldLeadTarget
)
{
	local RemoteBot remote;

	remote = super.AddRemoteBot(theConnection, clientName, TeamNum,
		className, DesiredSkin, DesiredSkill, ShouldLeadTarget);

	if (!AddRemoteBotToTeam(remote, TeamNum))
	{
		`log("In AddRemoteBot() - In Team Game Bot without team!");
		remote.Destroy();
		return None;
	}

	return remote;
}

function bool AddRemoteBotToTeam(RemoteBot NewBot, int TeamNum)
{
	local int i, DesiredTeam, MinSize, NextBotTeam;

	if ( teamGame.bPlayersBalanceTeams )
	{
		MinSize = teamGame.Teams[0].Size;
		DesiredTeam = 0;
		for ( i = 1; i < 2; ++i )
			if ( teamGame.Teams[i].Size < MinSize )
			{
				MinSize = teamGame.Teams[i].Size;
				DesiredTeam = i;
			}
	}
	else
		DesiredTeam = TeamNum;

	NewBot.PlayerReplicationInfo.bBot = True;

	if ( (DesiredTeam != 255) && teamGame.ChangeTeam(NewBot, DesiredTeam, true) )
	{
		return true;
	}
	else
	{
		`log("Can't add bot to team " $ DesiredTeam $ ". Using different.");
		for (NextBotTeam = 0; NextBotTeam < 2; NextBotTeam++)
		{
			if (teamGame.ChangeTeam(NewBot, NextBotTeam, true))
			{
				return true;
			}
		}
		`log("Adding to teams failed!!");
		return false;
	}
}

function UTTeamInfo GetEpicBotTeam(optional int TeamNumber)
{
	if ( teamGame.bPlayersBalanceTeams )
	{
		return teamGame.GetBotTeam();
	}
	else
	{
	 	if ((TeamNumber >= 0) && (TeamNumber < 2))
	 	{
			return teamGame.Teams[TeamNumber];
		}
		return teamGame.GetBotTeam();
	}
}

function NotifyKilled( Controller Killer, Controller Killed, Pawn KilledPawn, class<DamageType> damageType )
{
	local RemoteBot C;

	foreach WorldInfo.AllControllers(class'RemoteBot', C)
	{
		C.NotifyKilled(Killer, Killed, KilledPawn, damageType);
	}
}

DefaultProperties
{
}
